/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.base.CaseFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.JsonToNBTConverter;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.NBTToJsonConverter;
import me.desht.pneumaticcraft.common.util.PastebinHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PastebinScreen
extends AbstractPneumaticCraftScreen {
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private WidgetCheckBox prettyCB;
    private final CompoundTag pastingNBT;
    private final Screen parentScreen;
    private Component statusMessage = Component.m_237119_();
    private Component lastMessage = Component.m_237119_();
    private int messageTimer;
    private EnumState state = EnumState.NONE;
    CompoundTag outputTag;
    boolean shouldMerge;

    PastebinScreen(Screen parentScreen, CompoundTag tag) {
        super((Component)Component.m_237113_((String)"Pastebin"));
        this.xSize = 183;
        this.ySize = 202;
        this.pastingNBT = tag;
        this.parentScreen = parentScreen;
        Minecraft.m_91087_().f_91068_.m_90926_(true);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.f_96547_, this.guiLeft + 10, this.guiTop + 30, 80, 10);
            this.m_142416_((GuiEventListener)this.usernameBox);
            this.passwordBox = new WidgetTextField(this.f_96547_, this.guiLeft + 10, this.guiTop + 56, 80, 10).setAsPasswordBox();
            this.m_142416_((GuiEventListener)this.passwordBox);
            WidgetButtonExtended loginButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.login", new Object[0]), b -> this.login());
            loginButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loginOptional", new Object[0]));
            this.m_142416_((GuiEventListener)loginButton);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.username", new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.password", new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            WidgetButtonExtended logoutButton = new WidgetButtonExtended(this.guiLeft + 60, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.logout", new Object[0]), b -> this.logout());
            this.m_142416_((GuiEventListener)logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this.f_96547_, this.guiLeft + 10, this.guiTop + 130, 160, 10){

            protected void m_7207_(boolean focused) {
                if (focused) {
                    this.m_94201_();
                    this.m_94208_(0);
                }
                super.m_7207_(focused);
            }
        };
        this.m_142416_((GuiEventListener)this.pastebinBox);
        WidgetButtonExtended pasteButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 78, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.upload", new Object[0]), b -> this.sendToPastebin());
        this.m_142416_((GuiEventListener)pasteButton);
        WidgetButtonExtended getButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 167, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.get", new Object[0]), b -> this.getFromPastebin());
        this.m_142416_((GuiEventListener)getButton);
        WidgetButtonExtended putInClipBoard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 78, 20, 20, (Component)Component.m_237119_(), b -> this.putToClipboard());
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.copyToClipboard", new Object[0]));
        this.m_142416_((GuiEventListener)putInClipBoard);
        WidgetButtonExtended retrieveFromClipboard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 167, 20, 20, (Component)Component.m_237119_(), b -> this.getFromClipboard());
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.loadFromClipboard", new Object[0]));
        this.m_142416_((GuiEventListener)retrieveFromClipboard);
        this.prettyCB = new WidgetCheckBox(0, this.guiTop + 102, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pretty", new Object[0]), b -> {
            this.shouldMerge = b.checked;
        });
        this.prettyCB.f_93620_ = this.guiLeft + (170 - this.prettyCB.m_5711_());
        this.prettyCB.setTooltipKey("pneumaticcraft.gui.pastebin.pretty.tooltip");
        this.m_142416_((GuiEventListener)this.prettyCB);
        if (this.parentScreen instanceof ProgrammerScreen) {
            WidgetCheckBox mergeCB = new WidgetCheckBox(0, this.guiTop + 155, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge", new Object[0]), b -> {
                this.shouldMerge = b.checked;
            });
            mergeCB.f_93620_ = this.guiLeft + (170 - mergeCB.m_5711_());
            mergeCB.setTooltipKey("pneumaticcraft.gui.pastebin.merge.tooltip");
            this.m_142416_((GuiEventListener)mergeCB);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pastebinLink", new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    private void login() {
        PastebinHandler.login(this.usernameBox.m_94155_(), this.passwordBox.m_94155_());
        this.state = EnumState.LOGIN;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loggingIn", new Object[0]);
    }

    private void logout() {
        PastebinHandler.logout();
        this.state = EnumState.LOGOUT;
    }

    private void sendToPastebin() {
        PastebinHandler.put(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.state = EnumState.PUTTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadingToPastebin", new Object[0]);
    }

    private void getFromPastebin() {
        PastebinHandler.get(this.pastebinBox.m_94155_());
        this.state = EnumState.GETTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievingFromPastebin", new Object[0]);
    }

    private void putToClipboard() {
        this.f_96541_.f_91068_.m_90911_(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.clipboardSetToContents", new Object[0]);
    }

    private void getFromClipboard() {
        this.readFromString(this.f_96541_.f_91068_.m_90876_());
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.statusMessage = Component.m_237119_();
            switch (this.state) {
                case GETTING: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidPastebin", new Object[0]);
                    break;
                }
                case PUTTING: {
                    if (PastebinHandler.getException() != null) {
                        this.statusMessage = Component.m_237113_((String)PastebinHandler.getException().getMessage());
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.m_94144_(pastebinText);
                        this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadedToPastebin", new Object[0]));
                        break;
                    }
                    this.statusMessage = Component.m_237113_((String)pastebinText);
                    break;
                }
                case LOGIN: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidLogin", new Object[0]);
                    }
                    this.m_7856_();
                }
            }
            this.state = EnumState.NONE;
        }
        if (this.messageTimer > 0 && --this.messageTimer <= 0) {
            this.lastMessage = Component.m_237119_();
        }
    }

    private void setTempMessage(Component msg) {
        this.lastMessage = msg;
        this.messageTimer = 60;
    }

    private void readFromString(String string) {
        try {
            this.outputTag = new JsonToNBTConverter(string).convert();
            if (this.outputTag.m_128441_("widgets")) {
                this.doLegacyConversion(this.outputTag);
            }
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievedFromPastebin", new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidFormattedPastebin", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
    }

    private void doLegacyConversion(CompoundTag nbt) {
        ListTag l = nbt.m_128437_("widgets", 10);
        int areaConversions = 0;
        for (int i = 0; i < l.size(); ++i) {
            CompoundTag subTag = l.m_128728_(i);
            String newName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, subTag.m_128461_("name"));
            subTag.m_128359_("name", "pneumaticcraft:" + newName);
            if (!newName.equals("area")) continue;
            LegacyAreaWidgetConverter.EnumOldAreaType oldType = LegacyAreaWidgetConverter.EnumOldAreaType.values()[subTag.m_128451_("type")];
            AreaType newType = LegacyAreaWidgetConverter.convertFromLegacyFormat(oldType, subTag.m_128451_("typeInfo"));
            subTag.m_128359_("type", newType.getName());
            newType.writeToNBT(subTag);
            ++areaConversions;
        }
        nbt.m_128365_("pneumaticcraft:progWidgets", (Tag)l);
        nbt.m_128473_("widgets");
        if (areaConversions > 0) {
            Log.info("Pastebin import: converted %d legacy area widgets", areaConversions);
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTicks);
        if (!this.statusMessage.getString().isEmpty()) {
            PastebinScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.statusMessage, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)-256);
        } else if (!this.lastMessage.getString().isEmpty()) {
            PastebinScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.lastMessage, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)-16711936);
        }
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

