/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class PNCUpgrade {
    private static final AtomicInteger ids = new AtomicInteger();
    private final int maxTier;
    private final List<String> depModIds;
    private final int cacheId;

    public PNCUpgrade() {
        this(1, new String[0]);
    }

    public PNCUpgrade(int maxTier, String ... depModIds) {
        this.maxTier = maxTier;
        this.depModIds = ImmutableList.copyOf((Object[])depModIds);
        this.cacheId = ids.getAndIncrement();
    }

    public int getCacheId() {
        return this.cacheId;
    }

    public final int getMaxTier() {
        return this.maxTier;
    }

    public final boolean isDependencyLoaded() {
        return this.depModIds.isEmpty() || this.depModIds.stream().anyMatch(modid -> ModList.get().isLoaded(modid));
    }

    public final Item getItem(int tier) {
        ResourceLocation rl = PneumaticRegistry.getInstance().getUpgradeRegistry().getItemRegistryName(this, tier);
        return tier > this.maxTier || rl == null ? Items.f_41852_ : (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    public final Item getItem() {
        return this.getItem(1);
    }

    public final ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public final ItemStack getItemStack(int count) {
        Item item = this.getItem();
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return this.maxTier == 1 ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)this.getItem(count));
    }

    public static PNCUpgrade from(ItemStack stack) {
        PNCUpgrade pNCUpgrade;
        Item item = stack.m_41720_();
        if (item instanceof IUpgradeItem) {
            IUpgradeItem u = (IUpgradeItem)item;
            pNCUpgrade = u.getUpgradeType();
        } else {
            pNCUpgrade = null;
        }
        return pNCUpgrade;
    }
}

