/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksAroundPlayerHelper;

public class PacketReturnProtectedBlocksAroundPlayer {
    private Map<ChunkPos, Set<BlockPos>> blocks;

    public void fromBytes(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.blocks = new HashMap<ChunkPos, Set<BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            ChunkPos chunkpos = new ChunkPos(buf.readInt(), buf.readInt());
            int size2 = buf.readInt();
            HashSet<BlockPos> positions = new HashSet<BlockPos>(size2);
            for (int j = 0; j < size2; ++j) {
                positions.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
            }
            this.blocks.put(chunkpos, positions);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<ChunkPos, Set<BlockPos>> entry : this.blocks.entrySet()) {
            Set<BlockPos> positions = entry.getValue();
            buf.writeInt(entry.getKey().f_45578_);
            buf.writeInt(entry.getKey().f_45579_);
            buf.writeInt(positions.size());
            for (BlockPos block : positions) {
                buf.writeInt(block.m_123341_());
                buf.writeInt(block.m_123342_());
                buf.writeInt(block.m_123343_());
            }
        }
    }

    public Map<ChunkPos, Set<BlockPos>> getBlocks() {
        return this.blocks;
    }

    public PacketReturnProtectedBlocksAroundPlayer(FriendlyByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnProtectedBlocksAroundPlayer(Map<ChunkPos, Set<BlockPos>> blocks) {
        this.blocks = blocks;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnProtectedBlocksAroundPlayerHelper.setProtectedBlocks((ResourceKey<Level>)Level.f_46428_, this));
        ctx.setPacketHandled(true);
    }
}

