/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlockCount;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlockCountHelper;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksHelper;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.network.NEWPacketHandler;
import romelo333.notenoughwands.varia.Tools;

public class ProtectionWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_PROTECT = 0;
    public static final int MODE_UNPROTECT = 1;
    public static final int MODE_CLEAR = 2;
    public static final int MODE_LAST = 2;
    private final boolean master;
    public static final String[] descriptions = new String[]{"protect", "unprotect", "clear all"};
    private static long tooltipLastTime = 0L;
    private static long lastTime = 0L;

    public ProtectionWand(boolean master) {
        if (master) {
            this.usageFactor(3.0f);
        } else {
            this.usageFactor(3.0f);
        }
        this.master = master;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, world, list, flagIn);
        boolean hasid = stack.m_41783_() != null && stack.m_41783_().m_128441_("id");
        int mode = this.getMode(stack);
        int id = this.getId(stack);
        if (hasid && id != 0 && System.currentTimeMillis() - tooltipLastTime > 250L) {
            tooltipLastTime = System.currentTimeMillis();
            NEWPacketHandler.INSTANCE.sendToServer((Object)new PacketGetProtectedBlockCount(id));
        }
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Mode: " + descriptions[mode])));
        if (this.master) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Master wand")));
        } else if (id != 0) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Id: " + id)));
        }
        if (hasid) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Number of protected blocks: " + ReturnProtectedBlockCountHelper.count)));
        }
        list.add((Component)ComponentFactory.literal((String)"Right click to protect or unprotect a block."));
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + descriptions[mode] + " mode")));
        stack.m_41784_().m_128405_("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }

    public int getId(ItemStack stack) {
        if (this.master) {
            return -1;
        }
        return stack.m_41784_().m_128451_("id");
    }

    @Override
    public void renderOverlay(RenderLevelLastEvent evt, Player player, ItemStack wand) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            NEWPacketHandler.INSTANCE.sendToServer((Object)new PacketGetProtectedBlocks());
        }
        if (this.master) {
            ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.childBlocks, 30, 30, 200);
        }
        ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.blocks, 210, 60, 40);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            int id = this.getOrCreateId(stack, world, protectedBlocks);
            int mode = this.getMode(stack);
            if (mode == 0) {
                if (!this.checkUsage(stack, player, 1.0f)) {
                    return InteractionResult.FAIL;
                }
                if (!protectedBlocks.protect(player, world, pos, id)) {
                    return InteractionResult.FAIL;
                }
                this.registerUsage(stack, player, 1.0f);
            } else if (mode == 1) {
                if (!protectedBlocks.unprotect(player, world, pos, id)) {
                    return InteractionResult.FAIL;
                }
            } else {
                int cnt = protectedBlocks.clearProtections(world, id);
                Tools.notify(player, ComponentFactory.literal((String)("Cleared " + cnt + " protected blocks")));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getOrCreateId(ItemStack stack, Level world, ProtectedBlocks protectedBlocks) {
        int id = this.getId(stack);
        if (id == 0) {
            id = protectedBlocks.getNewId();
            stack.m_41784_().m_128405_("id", id);
        }
        return id;
    }

    public boolean m_41470_() {
        return !this.master;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (this.hasCraftingRemainingItem(stack) && stack.m_41782_()) {
            ItemStack container = new ItemStack((ItemLike)this.m_41469_());
            container.m_41751_(stack.m_41783_().m_6426_());
            return container;
        }
        return ItemStack.f_41583_;
    }
}

