/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SoundTools;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] DESCRIPTIONS = new String[]{"3x3", "5x5", "7x7", "single"};
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> DESCRIPTIONS[this.getMode((ItemStack)stack)])});

    public DisplacementWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + DESCRIPTIONS[mode] + " mode")));
        stack.m_41784_().m_128405_("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_("mode");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.pullBlocks(stack, player, world, pos, side);
            } else {
                this.pushBlocks(stack, player, world, pos, side);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void pullBlocks(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side);
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side.m_122424_());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(Player player, Level world, Set<BlockPos> coordinates, Direction direction) {
        int cnt = 0;
        for (BlockPos coordinate : coordinates) {
            double cost;
            BlockState state = world.m_8055_(coordinate);
            Block block = state.m_60734_();
            BlockPos otherC = coordinate.m_121945_(direction);
            BlockState otherState = world.m_8055_(otherC);
            if (!otherState.m_60767_().m_76336_() || !((cost = GenericWand.checkPickup(player, world, otherC, state, (Double)BuildingWandsConfiguration.maxHardness.get())) >= 0.0)) continue;
            ++cnt;
            SoundTools.playSound((Level)world, (SoundEvent)block.m_49962_(state).m_56776_(), (double)coordinate.m_123341_(), (double)coordinate.m_123342_(), (double)coordinate.m_123343_(), (double)1.0, (double)1.0);
            BlockEntity tileEntity = world.m_7702_(coordinate);
            CompoundTag tc = null;
            if (tileEntity != null) {
                tc = tileEntity.m_187482_();
                world.m_46747_(coordinate);
            }
            world.m_7731_(coordinate, Blocks.f_50016_.m_49966_(), 0);
            BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)otherC);
            BlockState blockState = block.m_49966_();
            world.m_7731_(otherC, blockState, 3);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(true, false);
                world.m_7731_(coordinate, blockState, 3);
                otherC = coordinate;
            }
            if (tc == null || (tileEntity = world.m_7702_(otherC)) == null) continue;
            tileEntity.m_142466_(tc);
            tileEntity.m_6596_();
            world.m_7260_(otherC, blockState, blockState, 3);
        }
        return cnt;
    }

    @Override
    public void renderOverlay(RenderLevelLastEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        if (mouseOver instanceof BlockHitResult) {
            BlockPos blockPos;
            BlockHitResult br = (BlockHitResult)mouseOver;
            Level world = player.m_20193_();
            BlockState state = world.m_8055_(blockPos = br.m_82425_());
            if (!state.m_60795_()) {
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.m_82434_(), blockPos);
                DisplacementWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(Level world, int x, int y, int z, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.m_46859_(pos)) {
            coordinates.add(pos);
        }
    }
}

