/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.network.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncMultiblockDataMessage
implements Message {
    public ConcurrentMap<ResourceLocation, Multiblock> multiblocks = new ConcurrentHashMap<ResourceLocation, Multiblock>();

    public SyncMultiblockDataMessage(ConcurrentMap<ResourceLocation, Multiblock> multiblocks) {
        this.multiblocks = multiblocks;
    }

    public SyncMultiblockDataMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.multiblocks.size());
        for (Multiblock multiblock : this.multiblocks.values()) {
            buf.m_130085_(multiblock.getType());
            buf.m_130085_(multiblock.getId());
            multiblock.toNetwork(buf);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        int multiblockCount = buf.m_130242_();
        for (int i = 0; i < multiblockCount; ++i) {
            ResourceLocation type = buf.m_130281_();
            ResourceLocation id = buf.m_130281_();
            Multiblock multiblock = LoaderRegistry.getMultiblockNetworkLoader(type).fromNetwork(buf);
            multiblock.setId(id);
            this.multiblocks.put(multiblock.getId(), multiblock);
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        MultiblockDataManager.get().onDatapackSyncPacket(this);
    }
}

