/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.capability.bookstate;

import com.klikli_dev.modonomicon.capability.bookstate.CategoryState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class BookState
implements INBTSerializable<CompoundTag> {
    public Map<ResourceLocation, CategoryState> categoryStates = new HashMap<ResourceLocation, CategoryState>();
    public ResourceLocation openCategory = null;

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag categoryStatesList = new ListTag();
        compound.m_128365_("category_states", (Tag)categoryStatesList);
        this.categoryStates.forEach((categoryId, state) -> {
            CompoundTag stateCompound = new CompoundTag();
            stateCompound.m_128359_("category_id", categoryId.toString());
            stateCompound.m_128365_("state", (Tag)state.serializeNBT());
            categoryStatesList.add((Object)stateCompound);
        });
        if (this.openCategory != null) {
            compound.m_128359_("open_category", this.openCategory.toString());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.categoryStates.clear();
        ListTag categoryStatesList = nbt.m_128437_("category_states", 10);
        for (Tag categoryStateEntry : categoryStatesList) {
            if (!(categoryStateEntry instanceof CompoundTag)) continue;
            CompoundTag categoryStateCompound = (CompoundTag)categoryStateEntry;
            ResourceLocation bookId = new ResourceLocation(categoryStateCompound.m_128461_("category_id"));
            CompoundTag stateCompound = categoryStateCompound.m_128469_("state");
            CategoryState state = new CategoryState();
            state.deserializeNBT(stateCompound);
            this.categoryStates.put(bookId, state);
        }
        if (nbt.m_128441_("open_category")) {
            this.openCategory = new ResourceLocation(nbt.m_128461_("open_category"));
        }
    }
}

