/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookEntryReadCondition
extends BookCondition {
    protected ResourceLocation entryId;

    public BookEntryReadCondition(Component tooltip, ResourceLocation entryId) {
        super(tooltip);
        this.entryId = entryId;
    }

    public static BookEntryReadCondition fromJson(JsonObject json) {
        ResourceLocation entryId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"entry_id"));
        MutableComponent tooltip = BookEntryReadCondition.tooltipFromJson(json);
        return new BookEntryReadCondition((Component)tooltip, entryId);
    }

    public static BookEntryReadCondition fromNetwork(FriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? buffer.m_130238_() : null;
        ResourceLocation entryId = buffer.m_130281_();
        return new BookEntryReadCondition(tooltip, entryId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.ENTRY_READ;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.m_130083_(this.tooltip);
        }
        buffer.m_130085_(this.entryId);
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        BookEntry entry = context.getBook().getEntry(this.entryId);
        if (entry == null) {
            throw new IllegalArgumentException("Entry with id " + this.entryId + " not found in book " + context.getBook().getId() + "for BookEntryReadCondition. This happened while trying to unlock " + context);
        }
        return BookUnlockCapability.isReadFor(player, entry);
    }

    @Override
    public List<Component> getTooltip(BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = Component.m_237110_((String)"tooltip.modonomicon..condition.entry_read", (Object[])new Object[]{Component.m_237115_((String)entryContext.getBook().getEntry(this.entryId).getName())});
        }
        return super.getTooltip(context);
    }
}

