/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.dynresources;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.ModelLocationCache;
import org.embeddedt.modernfix.util.ForwardingInclDefaultsMap;
import org.jetbrains.annotations.Nullable;

public class ModelBakeEventHelper {
    private static final Set<String> INCOMPATIBLE_MODS = ImmutableSet.of((Object)"industrialforegoing", (Object)"mekanism", (Object)"vampirism", (Object)"elevatorid");
    private final Map<ResourceLocation, BakedModel> modelRegistry;
    private final Set<ResourceLocation> topLevelModelLocations;
    private final MutableGraph<String> dependencyGraph;
    private static final Set<String> WARNED_MOD_IDS = new HashSet<String>();

    public ModelBakeEventHelper(Map<ResourceLocation, BakedModel> modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.topLevelModelLocations = new HashSet<ResourceLocation>(modelRegistry.keySet());
        for (Block block : ForgeRegistries.BLOCKS) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                this.topLevelModelLocations.add((ResourceLocation)ModelLocationCache.get(state));
            }
        }
        for (Item item : ForgeRegistries.ITEMS) {
            this.topLevelModelLocations.add((ResourceLocation)ModelLocationCache.get(item));
        }
        this.dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            this.dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                this.dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : this.dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                this.dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
    }

    private Map<ResourceLocation, BakedModel> createWarningRegistry(final String modId) {
        return new ForwardingInclDefaultsMap<ResourceLocation, BakedModel>(){

            protected Map<ResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            private void logWarning() {
                if (!WARNED_MOD_IDS.add(modId)) {
                    return;
                }
                ModernFix.LOGGER.warn("Mod '{}' is accessing Map#keySet/entrySet/values/replaceAll on the model registry map inside its event handler. This probably won't work as expected with dynamic resources on. Prefer using Map#get/put and constructing ModelResourceLocations another way.", (Object)modId);
            }

            public Set<ResourceLocation> keySet() {
                this.logWarning();
                return super.keySet();
            }

            public Set<Map.Entry<ResourceLocation, BakedModel>> entrySet() {
                this.logWarning();
                return super.entrySet();
            }

            public Collection<BakedModel> values() {
                this.logWarning();
                return super.values();
            }

            @Override
            public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
                this.logWarning();
                super.replaceAll(function);
            }
        };
    }

    public Map<ResourceLocation, BakedModel> wrapRegistry(final String modId) {
        final HashSet<String> modIdsToInclude = new HashSet<String>();
        modIdsToInclude.add(modId);
        try {
            modIdsToInclude.addAll(this.dependencyGraph.adjacentNodes((Object)modId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modIdsToInclude.remove("minecraft");
        if (modIdsToInclude.stream().noneMatch(INCOMPATIBLE_MODS::contains)) {
            return this.createWarningRegistry(modId);
        }
        final Set ourModelLocations = Sets.filter(this.topLevelModelLocations, loc -> modIdsToInclude.contains(loc.m_135827_()));
        final BakedModel missingModel = this.modelRegistry.get(ModelBakery.f_119230_);
        return new ForwardingMap<ResourceLocation, BakedModel>(){

            protected Map<ResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            public BakedModel get(@Nullable Object key) {
                BakedModel model = (BakedModel)super.get(key);
                if (model == null && key != null && modIdsToInclude.contains(((ResourceLocation)key).m_135827_())) {
                    ModernFix.LOGGER.warn("Model {} is missing, but was requested in model bake event. Returning missing model", key);
                    return missingModel;
                }
                return model;
            }

            public Set<ResourceLocation> keySet() {
                return ourModelLocations;
            }

            public boolean containsKey(@Nullable Object key) {
                return ourModelLocations.contains(key) || super.containsKey(key);
            }

            public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
                ModernFix.LOGGER.warn("Mod '{}' is calling replaceAll on the model registry. Some hacks will be used to keep this fast, but they may not be 100% compatible.", (Object)modId);
                ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>(this.keySet());
                for (ResourceLocation location : locations) {
                    BakedModel existing;
                    BakedModel replacement;
                    boolean needsReplacement;
                    try {
                        needsReplacement = function.apply((ResourceLocation)location, null) != null;
                    }
                    catch (Throwable e) {
                        needsReplacement = true;
                    }
                    if (!needsReplacement || (replacement = function.apply((ResourceLocation)location, (BakedModel)(existing = this.get(location)))) == existing) continue;
                    this.put(location, replacement);
                }
            }
        };
    }
}

