/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.util;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.util.CompressionVariant;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CompressionChain
extends ObjectArrayList<CompressionVariant> {
    public void add(AEItemKey item, int factor) {
        this.add(new CompressionVariant(item, factor));
    }

    public boolean containsVariant(AEItemKey item) {
        return this.stream().anyMatch(v -> v.item().equals((Object)item));
    }

    public BigInteger unitFactor(AEItemKey item) {
        Optional<CompressionVariant> variant = this.stream().filter(v -> v.item().equals((Object)item)).findFirst();
        if (variant.isEmpty()) {
            return BigInteger.ONE;
        }
        ObjectList subChain = this.subList(0, this.indexOf(variant.get()) + 1);
        Long factor = subChain.stream().map(CompressionVariant::longFactor).reduce(1L, Math::multiplyExact);
        return BigInteger.valueOf(factor);
    }

    public CompressionVariant last() {
        return (CompressionVariant)this.get(this.size - 1);
    }

    public CompressionChain lastMultiplierSwapped() {
        List multipliers = this.stream().map(CompressionVariant::factor).collect(Collectors.toList());
        Collections.rotate(multipliers, -1);
        List<AEItemKey> items = this.stream().map(CompressionVariant::item).toList();
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < items.size(); ++i) {
            chain.add(items.get(i), (Integer)multipliers.get(i));
        }
        return chain;
    }

    public CompressionChain reversed() {
        CompressionChain chain = new CompressionChain();
        for (int i = this.size - 1; i >= 0; --i) {
            chain.add((CompressionVariant)this.get(i));
        }
        return chain;
    }
}

