/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class BiomeCheckTest {
    private static final BlockPos TEST_POS = new BlockPos(1, 0, 1);

    @GameTest(m_177046_="empty_test_structure")
    public void AnyBiomeCheck_match(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        ResourceLocation biome = helper.m_177100_().m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)biomeHolder.m_203334_()));
        ResourceKey<Biome> bKey = this.biome(biome);
        AnyBiomeCheck check = new AnyBiomeCheck(Collections.singletonList(bKey), new ArrayList<TagKey<Biome>>());
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "Biome " + bKey.m_135782_() + " check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void BiomeCheck_match(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        ResourceLocation biome = helper.m_177100_().m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)biomeHolder.m_203334_()));
        ResourceKey<Biome> bKey = this.biome(biome);
        BiomeCheck check = new BiomeCheck(Collections.singletonList(bKey), new ArrayList<TagKey<Biome>>());
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "Biome " + bKey.m_135782_() + " check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void AnyBiomeCheck_fail(GameTestHelper helper) {
        Player player = helper.m_177368_();
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        ResourceKey<Biome> bKey = this.biome(new ResourceLocation("minecraft:deep_ocean"));
        AnyBiomeCheck check = new AnyBiomeCheck(Collections.singletonList(bKey), new ArrayList<TagKey<Biome>>());
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, check.test(ctx), "Biome " + bKey.m_135782_() + " check should not pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void BiomeCheck_fail(GameTestHelper helper) {
        Player player = helper.m_177368_();
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        ResourceKey<Biome> bKey = this.biome(new ResourceLocation("minecraft:deep_ocean"));
        BiomeCheck check = new BiomeCheck(Collections.singletonList(bKey), new ArrayList<TagKey<Biome>>());
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, check.test(ctx), "Biome " + bKey.m_135782_() + " check should not pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void AnyBiomeCheck_matchTags(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        List types = biomeHolder.m_203616_().toList();
        AnyBiomeCheck check = new AnyBiomeCheck(new ArrayList<ResourceKey<Biome>>(), new ArrayList<TagKey<Biome>>(types));
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "Biome " + BuiltinRegistries.f_123865_.m_7981_((Object)((Biome)biomeHolder.m_203334_())) + " tag check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void BiomeCheck_matchAllTags(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        List types = biomeHolder.m_203616_().toList();
        BiomeCheck check = new BiomeCheck(new ArrayList<ResourceKey<Biome>>(), new ArrayList<TagKey<Biome>>(types));
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "Biome " + BuiltinRegistries.f_123865_.m_7981_((Object)((Biome)biomeHolder.m_203334_())) + " tag check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void AnyBiomeCheck_failAllTags(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        AnyBiomeCheck check = new AnyBiomeCheck(new ArrayList<ResourceKey<Biome>>(), Collections.singletonList(BiomeTags.f_207612_));
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, check.test(ctx), "Biome " + BuiltinRegistries.f_123865_.m_7981_((Object)((Biome)biomeHolder.m_203334_())) + " tag check should not pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void BiomeCheck_failAllTags(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Holder biomeHolder = helper.m_177100_().m_204166_(TEST_POS);
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), player.m_20182_());
        BiomeCheck check = new BiomeCheck(new ArrayList<ResourceKey<Biome>>(), Collections.singletonList(BiomeTags.f_207612_));
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, check.test(ctx), "Biome " + BuiltinRegistries.f_123865_.m_7981_((Object)((Biome)biomeHolder.m_203334_())) + " tag check should not pass"));
    }

    public ResourceKey<Biome> biome(ResourceLocation biome) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)Objects.requireNonNull(biome));
    }
}

