/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ShaderHolder {
    public final ResourceLocation shaderLocation;
    public final VertexFormat shaderFormat;
    protected ExtendedShaderInstance shaderInstance;
    public Collection<String> uniformsToCache;
    private final RenderStateShard.ShaderStateShard shard = new RenderStateShard.ShaderStateShard(this.getInstance());

    public ShaderHolder(ResourceLocation shaderLocation, VertexFormat shaderFormat, String ... uniformsToCache) {
        this.shaderLocation = shaderLocation;
        this.shaderFormat = shaderFormat;
        this.uniformsToCache = new ArrayList<String>(List.of(uniformsToCache));
    }

    public ExtendedShaderInstance createInstance(ResourceManager resourceManager) throws IOException {
        ExtendedShaderInstance shaderInstance;
        final ShaderHolder shaderHolder = this;
        this.shaderInstance = shaderInstance = new ExtendedShaderInstance((ResourceProvider)resourceManager, this.shaderLocation, this.shaderFormat){

            @Override
            public ShaderHolder getShaderHolder() {
                return shaderHolder;
            }
        };
        return shaderInstance;
    }

    public Supplier<ShaderInstance> getInstance() {
        return () -> this.shaderInstance;
    }

    public RenderStateShard.ShaderStateShard getShard() {
        return this.shard;
    }
}

