/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class RenderTypeProvider {
    private final Function<ResourceLocation, RenderType> function;
    private final Function<ResourceLocation, RenderType> memorizedFunction;

    public RenderTypeProvider(Function<ResourceLocation, RenderType> function) {
        this.function = function;
        this.memorizedFunction = Util.m_143827_(function);
    }

    public RenderType apply(ResourceLocation texture) {
        return this.function.apply(texture);
    }

    public RenderType apply(ResourceLocation texture, ShaderUniformHandler uniformHandler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(this.function.apply(texture), uniformHandler);
    }

    public RenderType applyAndCache(ResourceLocation texture) {
        return this.memorizedFunction.apply(texture);
    }
}

