/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.postprocess;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.LodestoneLib;

public abstract class PostProcessor {
    protected static final Minecraft MC = Minecraft.m_91087_();
    public static final Collection<Pair<String, Consumer<Uniform>>> COMMON_UNIFORMS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"cameraPos", u -> u.m_142276_(new Vector3f(PostProcessor.MC.f_91063_.m_109153_().m_90583_()))), Pair.of((Object)"lookVector", u -> u.m_142276_(PostProcessor.MC.f_91063_.m_109153_().m_90596_())), Pair.of((Object)"upVector", u -> u.m_142276_(PostProcessor.MC.f_91063_.m_109153_().m_90597_())), Pair.of((Object)"leftVector", u -> u.m_142276_(PostProcessor.MC.f_91063_.m_109153_().m_167686_())), Pair.of((Object)"invViewMat", u -> {
        Matrix4f invertedViewMatrix = new Matrix4f(viewModelStack.m_85850_().m_85861_());
        invertedViewMatrix.m_27657_();
        u.m_5679_(invertedViewMatrix);
    }), Pair.of((Object)"invProjMat", u -> {
        Matrix4f invertedProjectionMatrix = new Matrix4f(RenderSystem.m_157192_());
        invertedProjectionMatrix.m_27657_();
        u.m_5679_(invertedProjectionMatrix);
    }), Pair.of((Object)"nearPlaneDistance", u -> u.m_5985_(0.05f)), Pair.of((Object)"farPlaneDistance", u -> u.m_5985_(PostProcessor.MC.f_91063_.m_172790_())), Pair.of((Object)"fov", u -> u.m_5985_((float)Math.toRadians(PostProcessor.MC.f_91063_.m_109141_(PostProcessor.MC.f_91063_.m_109153_(), MC.m_91296_(), true)))), Pair.of((Object)"aspectRatio", u -> u.m_5985_((float)MC.m_91268_().m_85441_() / (float)MC.m_91268_().m_85442_()))});
    public static PoseStack viewModelStack;
    private boolean initialized = false;
    protected PostChain postChain;
    protected EffectInstance[] effects;
    private RenderTarget tempDepthBuffer;
    private Collection<Pair<Uniform, Consumer<Uniform>>> defaultUniforms;
    private boolean isActive = true;
    protected double time;

    public abstract ResourceLocation getPostChainLocation();

    public void init() {
        this.loadPostChain();
        if (this.postChain != null) {
            this.tempDepthBuffer = this.postChain.m_110036_("depthMain");
            this.defaultUniforms = new ArrayList<Pair<Uniform, Consumer<Uniform>>>();
            for (EffectInstance e : this.effects) {
                for (Pair<String, Consumer<Uniform>> pair : COMMON_UNIFORMS) {
                    Uniform u = e.m_108952_((String)pair.getFirst());
                    if (u == null) continue;
                    this.defaultUniforms.add((Pair<Uniform, Consumer<Uniform>>)Pair.of((Object)u, (Object)((Consumer)pair.getSecond())));
                }
            }
        }
        this.initialized = true;
    }

    public final void loadPostChain() {
        if (this.postChain != null) {
            this.postChain.close();
            this.postChain = null;
        }
        try {
            ResourceLocation file = this.getPostChainLocation();
            file = new ResourceLocation(file.m_135827_(), "shaders/post/" + file.m_135815_() + ".json");
            this.postChain = new PostChain(MC.m_91097_(), MC.m_91098_(), MC.m_91385_(), file);
            this.postChain.m_110025_(MC.m_91268_().m_85441_(), MC.m_91268_().m_85442_());
            this.effects = (EffectInstance[])this.postChain.f_110009_.stream().map(PostPass::m_110074_).toArray(EffectInstance[]::new);
        }
        catch (JsonParseException | IOException e) {
            LodestoneLib.LOGGER.error("Failed to load post-processing shader: ", e);
        }
    }

    public final void copyDepthBuffer() {
        if (this.isActive) {
            if (this.postChain == null || this.tempDepthBuffer == null) {
                return;
            }
            this.tempDepthBuffer.m_83945_(MC.m_91385_());
            GlStateManager.m_84486_((int)36009, (int)PostProcessor.MC.m_91385_().f_83920_);
        }
    }

    public void resize(int width, int height) {
        if (this.postChain != null) {
            this.postChain.m_110025_(width, height);
            if (this.tempDepthBuffer != null) {
                this.tempDepthBuffer.m_83941_(width, height, Minecraft.f_91002_);
            }
        }
    }

    private void applyDefaultUniforms() {
        Arrays.stream(this.effects).forEach(e -> e.m_108960_("time").m_5985_((float)this.time));
        this.defaultUniforms.forEach(pair -> ((Consumer)pair.getSecond()).accept((Uniform)pair.getFirst()));
    }

    public final void applyPostProcess() {
        if (this.isActive) {
            if (!this.initialized) {
                this.init();
            }
            if (this.postChain != null) {
                this.time += (double)MC.m_91297_() / 20.0;
                this.applyDefaultUniforms();
                this.beforeProcess(viewModelStack);
                if (!this.isActive) {
                    return;
                }
                this.postChain.m_110023_(MC.m_91296_());
                GlStateManager.m_84486_((int)36009, (int)PostProcessor.MC.m_91385_().f_83920_);
                this.afterProcess();
            }
        }
    }

    public abstract void beforeProcess(PoseStack var1);

    public abstract void afterProcess();

    public final void setActive(boolean active) {
        this.isActive = active;
        if (!active) {
            this.time = 0.0;
        }
    }

    public final boolean isActive() {
        return this.isActive;
    }
}

