/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Vector3d;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.base.TextureSheetScreenParticle;

public class GenericScreenParticle
extends TextureSheetScreenParticle {
    private final LodestoneScreenParticleRenderType renderType;
    protected final ParticleEngine.MutableSpriteSet spriteSet;
    protected final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    protected final SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType;
    protected final ColorParticleData colorData;
    protected final GenericParticleData transparencyData;
    protected final GenericParticleData scaleData;
    protected final SpinParticleData spinData;
    protected final Consumer<GenericScreenParticle> actor;
    private final boolean tracksStack;
    private double stackTrackXOffset;
    private double stackTrackYOffset;
    private boolean reachedPositiveAlpha;
    private boolean reachedPositiveScale;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericScreenParticle(ClientLevel world, ScreenParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double xMotion, double yMotion) {
        super(world, x, y);
        this.renderType = options.renderType;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.discardFunctionType = options.discardFunctionType;
        this.colorData = options.colorData;
        this.transparencyData = options.transparencyData;
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.actor = options.actor;
        this.tracksStack = options.tracksStack;
        this.stackTrackXOffset = options.stackTrackXOffset;
        this.stackTrackYOffset = options.stackTrackYOffset;
        this.roll = options.spinData.spinOffset + options.spinData.startingValue;
        this.xMotion = xMotion;
        this.yMotion = yMotion;
        this.setLifetime(options.lifetime);
        this.gravity = options.gravity;
        this.friction = 1.0f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        this.updateTraits();
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE)) {
            this.pickSprite((SpriteSet)spriteSet);
        }
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX) || this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.pickSprite(0);
        }
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.LAST_INDEX)) {
            this.pickSprite(spriteSet.f_107406_.size() - 1);
        }
        this.updateTraits();
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.f_107406_.size() && spriteIndex >= 0) {
            this.setSprite((TextureAtlasSprite)this.spriteSet.f_107406_.get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = Mth.m_14189_((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    public float getCurve(float multiplier) {
        return Mth.m_14036_((float)((float)this.age * multiplier / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    protected void updateTraits() {
        boolean shouldAttemptRemoval;
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.age, this.lifetime) > 0.5f || this.transparencyData.getProgress(this.age, this.lifetime) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.alpha <= 0.0f || this.reachedPositiveScale && this.quadSize <= 0.0f)) {
            this.remove();
            return;
        }
        if (!this.reachedPositiveAlpha && this.alpha > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.quadSize > 0.0f) {
            this.reachedPositiveScale = true;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.age, this.lifetime), 0.0f, 1.0f, 1.0f));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime);
        this.alpha = this.transparencyData.getValue(this.age, this.lifetime);
        this.oRoll = this.roll;
        this.roll += this.spinData.getValue(this.age, this.lifetime);
        if (this.actor != null) {
            this.actor.accept(this);
        }
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        if (this.tracksStack) {
            this.x = (double)ScreenParticleHandler.currentItemX + this.stackTrackXOffset + this.xMoved;
            this.y = (double)ScreenParticleHandler.currentItemY + this.stackTrackYOffset + this.yMoved;
        }
        super.render(bufferBuilder);
    }

    @Override
    public void tick() {
        this.updateTraits();
        if (this.getSpritePicker().equals((Object)SimpleParticleOptions.ParticleSpritePicker.WITH_AGE)) {
            this.setSpriteFromAge((SpriteSet)this.spriteSet);
        }
        super.tick();
    }

    @Override
    public LodestoneScreenParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void setParticleSpeed(Vector3d speed) {
        this.setParticleSpeed(speed.f_86214_, speed.f_86215_);
    }
}

