/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data;

import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;

public class GenericParticleData {
    public final float startingValue;
    public final float middleValue;
    public final float endingValue;
    public final float coefficient;
    public final Easing startToMiddleEasing;
    public final Easing middleToEndEasing;

    protected GenericParticleData(float startingValue, float middleValue, float endingValue, float coefficient, Easing startToMiddleEasing, Easing middleToEndEasing) {
        this.startingValue = startingValue;
        this.middleValue = middleValue;
        this.endingValue = endingValue;
        this.coefficient = coefficient;
        this.startToMiddleEasing = startToMiddleEasing;
        this.middleToEndEasing = middleToEndEasing;
    }

    public boolean isTrinary() {
        return this.endingValue != -1.0f;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.m_14036_((float)(age * this.coefficient / lifetime), (float)0.0f, (float)1.0f);
    }

    public float getValue(float age, float lifetime) {
        float progress = this.getProgress(age, lifetime);
        if (this.isTrinary()) {
            if (progress >= 0.5f) {
                return Mth.m_14179_((float)this.middleToEndEasing.ease(progress - 0.5f, 0.0f, 1.0f, 0.5f), (float)this.middleValue, (float)this.endingValue);
            }
            return Mth.m_14179_((float)this.startToMiddleEasing.ease(progress, 0.0f, 1.0f, 0.5f), (float)this.startingValue, (float)this.middleValue);
        }
        return Mth.m_14179_((float)this.startToMiddleEasing.ease(progress, 0.0f, 1.0f, 1.0f), (float)this.startingValue, (float)this.middleValue);
    }

    public static GenericParticleDataBuilder create(float value) {
        return new GenericParticleDataBuilder(value, value, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static class GenericParticleDataBuilder {
        protected final float startingValue;
        protected final float middleValue;
        protected final float endingValue;
        protected float coefficient = 1.0f;
        protected Easing startToMiddleEasing = Easing.LINEAR;
        protected Easing middleToEndEasing = Easing.LINEAR;

        protected GenericParticleDataBuilder(float startingValue, float middleValue, float endingValue) {
            this.startingValue = startingValue;
            this.middleValue = middleValue;
            this.endingValue = endingValue;
        }

        public GenericParticleDataBuilder setCoefficient(float coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        public GenericParticleDataBuilder setEasing(Easing easing) {
            this.startToMiddleEasing = easing;
            return this;
        }

        public GenericParticleDataBuilder setEasing(Easing easing, Easing middleToEndEasing) {
            this.startToMiddleEasing = easing;
            this.middleToEndEasing = easing;
            return this;
        }

        public GenericParticleData build() {
            return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing);
        }
    }
}

