/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data;

import java.awt.Color;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;

public class ColorParticleData {
    public final float r1;
    public final float g1;
    public final float b1;
    public final float r2;
    public final float g2;
    public final float b2;
    public final float colorCoefficient;
    public final Easing colorCurveEasing;

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float colorCoefficient, Easing colorCurveEasing) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.colorCoefficient = colorCoefficient;
        this.colorCurveEasing = colorCurveEasing;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.m_14036_((float)(age * this.colorCoefficient / lifetime), (float)0.0f, (float)1.0f);
    }

    public static ColorParticleDataBuilder create(float r1, float g1, float b1, float r2, float g2, float b2) {
        return new ColorParticleDataBuilder(r1, g1, b1, r2, g2, b2);
    }

    public static ColorParticleDataBuilder create(Color start, Color end) {
        return ColorParticleData.create((float)start.getRed() / 255.0f, (float)start.getGreen() / 255.0f, (float)start.getBlue() / 255.0f, (float)end.getRed() / 255.0f, (float)end.getGreen() / 255.0f, (float)end.getBlue() / 255.0f);
    }

    public static class ColorParticleDataBuilder {
        protected final float r1;
        protected final float g1;
        protected final float b1;
        protected final float r2;
        protected final float g2;
        protected final float b2;
        protected float colorCoefficient = 1.0f;
        protected Easing colorCurveEasing = Easing.LINEAR;

        protected ColorParticleDataBuilder(float r1, float g1, float b1, float r2, float g2, float b2) {
            this.r1 = r1;
            this.g1 = g1;
            this.b1 = b1;
            this.r2 = r2;
            this.g2 = g2;
            this.b2 = b2;
        }

        public ColorParticleDataBuilder setCoefficient(float coefficient) {
            this.colorCoefficient = coefficient;
            return this;
        }

        public ColorParticleDataBuilder setEasing(Easing easing) {
            this.colorCurveEasing = easing;
            return this;
        }

        public ColorParticleData build() {
            return new ColorParticleData(this.r1, this.g1, this.b1, this.r2, this.g2, this.b2, this.colorCoefficient, this.colorCurveEasing);
        }
    }
}

