/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle;

import com.mojang.math.Vector3d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.block.BlockPosHelper;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.GenericParticle;
import team.lodestar.lodestone.systems.particle.world.WorldParticleOptions;

public class WorldParticleBuilder {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    final ParticleType<?> type;
    final WorldParticleOptions options;
    double xMotion = 0.0;
    double yMotion = 0.0;
    double zMotion = 0.0;
    double maxXSpeed = 0.0;
    double maxYSpeed = 0.0;
    double maxZSpeed = 0.0;
    double maxXOffset = 0.0;
    double maxYOffset = 0.0;
    double maxZOffset = 0.0;

    public static WorldParticleBuilder create(ParticleType<?> type) {
        return new WorldParticleBuilder(type);
    }

    public static WorldParticleBuilder create(RegistryObject<?> type) {
        return new WorldParticleBuilder((ParticleType)type.get());
    }

    protected WorldParticleBuilder(ParticleType<?> type) {
        this.type = type;
        this.options = new WorldParticleOptions(type);
    }

    public WorldParticleBuilder setColorData(ColorParticleData colorData) {
        this.options.colorData = colorData;
        return this;
    }

    public WorldParticleBuilder setScaleData(GenericParticleData scaleData) {
        this.options.scaleData = scaleData;
        return this;
    }

    public WorldParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        this.options.transparencyData = transparencyData;
        return this;
    }

    public WorldParticleBuilder setSpinData(SpinParticleData spinData) {
        this.options.spinData = spinData;
        return this;
    }

    public WorldParticleBuilder setGravity(float gravity) {
        this.options.gravity = gravity;
        return this;
    }

    public WorldParticleBuilder enableNoClip() {
        this.options.noClip = true;
        return this;
    }

    public WorldParticleBuilder disableNoClip() {
        this.options.noClip = false;
        return this;
    }

    public WorldParticleBuilder setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        this.options.spritePicker = spritePicker;
        return this;
    }

    public WorldParticleBuilder setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType) {
        this.options.discardFunctionType = discardFunctionType;
        return this;
    }

    public WorldParticleBuilder setRenderType(ParticleRenderType renderType) {
        this.options.renderType = renderType;
        return this;
    }

    public WorldParticleBuilder setLifetime(int lifetime) {
        this.options.lifetime = lifetime;
        return this;
    }

    public WorldParticleBuilder setRandomMotion(double maxSpeed) {
        return this.setRandomMotion(maxSpeed, maxSpeed, maxSpeed);
    }

    public WorldParticleBuilder setRandomMotion(double maxHSpeed, double maxVSpeed) {
        return this.setRandomMotion(maxHSpeed, maxVSpeed, maxHSpeed);
    }

    public WorldParticleBuilder setRandomMotion(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
        this.maxXSpeed = maxXSpeed;
        this.maxYSpeed = maxYSpeed;
        this.maxZSpeed = maxZSpeed;
        return this;
    }

    public WorldParticleBuilder addMotion(double vx, double vy, double vz) {
        this.xMotion += vx;
        this.yMotion += vy;
        this.zMotion += vz;
        return this;
    }

    public WorldParticleBuilder setMotion(double vx, double vy, double vz) {
        this.xMotion = vx;
        this.yMotion = vy;
        this.zMotion = vz;
        return this;
    }

    public WorldParticleBuilder setRandomOffset(double maxDistance) {
        return this.setRandomOffset(maxDistance, maxDistance, maxDistance);
    }

    public WorldParticleBuilder setRandomOffset(double maxHDist, double maxVDist) {
        return this.setRandomOffset(maxHDist, maxVDist, maxHDist);
    }

    public WorldParticleBuilder setRandomOffset(double maxXDist, double maxYDist, double maxZDist) {
        this.maxXOffset = maxXDist;
        this.maxYOffset = maxYDist;
        this.maxZOffset = maxZDist;
        return this;
    }

    public WorldParticleBuilder act(Consumer<WorldParticleBuilder> particleBuilderConsumer) {
        particleBuilderConsumer.accept(this);
        return this;
    }

    public WorldParticleBuilder addActor(Consumer<GenericParticle> particleActor) {
        this.options.actor = particleActor;
        return this;
    }

    public WorldParticleBuilder spawn(Level level, double x, double y, double z) {
        double yaw = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.m_188501_() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        double yaw2 = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch2 = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xDist = (double)RANDOM.m_188501_() * this.maxXOffset;
        double yDist = (double)RANDOM.m_188501_() * this.maxYOffset;
        double zDist = (double)RANDOM.m_188501_() * this.maxZOffset;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        double zPos = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
        level.m_7106_((ParticleOptions)this.options, x + xPos, y + yPos, z + zPos, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeat(Level level, double x, double y, double z, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(level, x, y, z);
        }
        return this;
    }

    public WorldParticleBuilder surroundBlock(Level level, BlockPos pos, Direction ... directions) {
        if (directions.length == 0) {
            directions = Direction.values();
        }
        for (Direction direction : directions) {
            double yaw = (double)RANDOM.m_188501_() * Math.PI * 2.0;
            double pitch = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
            double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
            double zSpeed = (double)RANDOM.m_188501_() * this.maxZSpeed;
            this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.yMotion += Math.sin(pitch) * ySpeed;
            this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = 0.5625;
            double xPos = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : RANDOM.m_188500_();
            double yPos = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : RANDOM.m_188500_();
            double zPos = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : RANDOM.m_188500_();
            level.m_7106_((ParticleOptions)this.options, (double)pos.m_123341_() + xPos, (double)pos.m_123342_() + yPos, (double)pos.m_123343_() + zPos, this.xMotion, this.yMotion, this.zMotion);
        }
        return this;
    }

    public WorldParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n) {
        for (int i = 0; i < n; ++i) {
            this.surroundBlock(level, pos, new Direction[0]);
        }
        return this;
    }

    public WorldParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n, Direction ... directions) {
        for (int i = 0; i < n; ++i) {
            this.surroundBlock(level, pos, directions);
        }
        return this;
    }

    public WorldParticleBuilder surroundVoxelShape(Level level, BlockPos pos, VoxelShape voxelShape, int max) {
        int[] c = new int[1];
        int perBoxMax = max / voxelShape.m_83299_().size();
        Supplier<Boolean> r = () -> {
            c[0] = c[0] + 1;
            if (c[0] >= perBoxMax) {
                c[0] = 0;
                return true;
            }
            return false;
        };
        Vec3 v = BlockPosHelper.fromBlockPos(pos);
        voxelShape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 b = v.m_82520_(x1, y1, z1);
            Vec3 e = v.m_82520_(x2, y2, z2);
            ArrayList<Runnable> runs = new ArrayList<Runnable>();
            runs.add(() -> this.spawnLine(level, b, v.m_82520_(x2, y1, z1)));
            runs.add(() -> this.spawnLine(level, b, v.m_82520_(x1, y2, z1)));
            runs.add(() -> this.spawnLine(level, b, v.m_82520_(x1, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x1, y2, z2)));
            runs.add(() -> this.spawnLine(level, e, v.m_82520_(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, e, v.m_82520_(x1, y2, z2)));
            runs.add(() -> this.spawnLine(level, e, v.m_82520_(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x2, y1, z2)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y2, z1)));
            runs.add(() -> this.spawnLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x1, y2, z2)));
            Collections.shuffle(runs);
            for (Runnable runnable : runs) {
                runnable.run();
                if (!((Boolean)r.get()).booleanValue()) continue;
                break;
            }
        });
        return this;
    }

    public WorldParticleBuilder surroundVoxelShape(Level level, BlockPos pos, BlockState state, int max) {
        VoxelShape voxelShape = state.m_60808_((BlockGetter)level, pos);
        if (voxelShape.m_83281_()) {
            voxelShape = Shapes.m_83144_();
        }
        return this.surroundVoxelShape(level, pos, voxelShape, max);
    }

    public WorldParticleBuilder spawnAtRandomFace(Level level, BlockPos pos) {
        Direction direction = Direction.values()[RANDOM.m_188503_(Direction.values().length)];
        double yaw = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.m_188501_() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        Direction.Axis direction$axis = direction.m_122434_();
        double d0 = 0.5625;
        double xPos = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : RANDOM.m_188500_();
        double yPos = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : RANDOM.m_188500_();
        double zPos = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : RANDOM.m_188500_();
        level.m_7106_((ParticleOptions)this.options, (double)pos.m_123341_() + xPos, (double)pos.m_123342_() + yPos, (double)pos.m_123343_() + zPos, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeatRandomFace(Level level, BlockPos pos, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawnAtRandomFace(level, pos);
        }
        return this;
    }

    public WorldParticleBuilder createCircle(Level level, double x, double y, double z, double distance, double currentCount, double totalCount) {
        double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.m_188501_() * this.maxZSpeed;
        double theta = Math.PI * 2 / totalCount;
        double finalAngle = currentCount / totalCount + theta * currentCount;
        double dx2 = distance * Math.cos(finalAngle);
        double dz2 = distance * Math.sin(finalAngle);
        Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
        this.xMotion = vector2f.f_86214_ * xSpeed;
        this.zMotion = vector2f.f_86216_ * zSpeed;
        double yaw2 = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch2 = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xDist = (double)RANDOM.m_188501_() * this.maxXOffset;
        double yDist = (double)RANDOM.m_188501_() * this.maxYOffset;
        double zDist = (double)RANDOM.m_188501_() * this.maxZOffset;
        double xPos = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
        double yPos = Math.sin(pitch2) * yDist;
        double zPos = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
        level.m_7106_((ParticleOptions)this.options, x + xPos + dx2, y + yPos, z + zPos + dz2, this.xMotion, ySpeed, this.zMotion);
        return this;
    }

    public WorldParticleBuilder repeatCircle(Level level, double x, double y, double z, double distance, int times) {
        for (int i = 0; i < times; ++i) {
            this.createCircle(level, x, y, z, distance, i, times);
        }
        return this;
    }

    public WorldParticleBuilder createBlockOutline(Level level, BlockPos pos, BlockState state) {
        VoxelShape voxelShape = state.m_60808_((BlockGetter)level, pos);
        double d = 0.25;
        voxelShape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v = BlockPosHelper.fromBlockPos(pos);
            Vec3 b = BlockPosHelper.fromBlockPos(pos).m_82520_(x1, y1, z1);
            Vec3 e = BlockPosHelper.fromBlockPos(pos).m_82520_(x2, y2, z2);
            this.spawnLine(level, b, v.m_82520_(x2, y1, z1));
            this.spawnLine(level, b, v.m_82520_(x1, y2, z1));
            this.spawnLine(level, b, v.m_82520_(x1, y1, z2));
            this.spawnLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x2, y2, z1));
            this.spawnLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x1, y2, z2));
            this.spawnLine(level, e, v.m_82520_(x2, y2, z1));
            this.spawnLine(level, e, v.m_82520_(x1, y2, z2));
            this.spawnLine(level, e, v.m_82520_(x2, y1, z2));
            this.spawnLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y1, z2));
            this.spawnLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x2, y1, z2));
            this.spawnLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y2, z1));
            this.spawnLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x1, y2, z2));
        });
        return this;
    }

    public WorldParticleBuilder spawnLine(Level level, Vec3 one, Vec3 two) {
        double yaw = (double)RANDOM.m_188501_() * Math.PI * 2.0;
        double pitch = (double)RANDOM.m_188501_() * Math.PI - 1.5707963267948966;
        double xSpeed = (double)RANDOM.m_188501_() * this.maxXSpeed;
        double ySpeed = (double)RANDOM.m_188501_() * this.maxYSpeed;
        double zSpeed = (double)RANDOM.m_188501_() * this.maxZSpeed;
        this.xMotion += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
        this.yMotion += Math.sin(pitch) * ySpeed;
        this.zMotion += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
        Vec3 pos = one.m_165921_(two, RANDOM.m_188500_());
        level.m_7106_((ParticleOptions)this.options, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.xMotion, this.yMotion, this.zMotion);
        return this;
    }
}

