/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.providers;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockModelProvider;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.ModularBlockStateSmith;

public abstract class LodestoneBlockStateProvider
extends BlockStateProvider {
    public final Set<ResourceLocation> staticTextures = new HashSet<ResourceLocation>();
    private final LodestoneBlockModelProvider blockModels;
    public final LodestoneItemModelProvider itemModelProvider;
    private String texturePath = "";

    public LodestoneBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper, LodestoneItemModelProvider itemModelProvider) {
        super(gen, modid, exFileHelper);
        this.itemModelProvider = itemModelProvider;
        this.blockModels = new LodestoneBlockModelProvider(this, gen, modid, exFileHelper);
    }

    public LodestoneBlockModelProvider models() {
        return this.blockModels;
    }

    public LodestoneItemModelProvider itemModels() {
        return this.itemModelProvider;
    }

    public void setTexturePath(String texturePath) {
        this.texturePath = texturePath;
    }

    public String getTexturePath() {
        return this.texturePath;
    }

    public ModularBlockStateSmith.ModelFileSupplier fromFunction(BiFunction<String, ResourceLocation, ModelFile> modelFileFunction) {
        return b -> {
            String name = this.getBlockName(b);
            return (ModelFile)modelFileFunction.apply(name, this.getBlockTexture(name));
        };
    }

    public ModelFile predefinedModel(Block block) {
        return this.models().getExistingFile(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public ModelFile predefinedModel(Block block, String extension) {
        return this.models().getExistingFile(this.extend(ForgeRegistries.BLOCKS.getKey((Object)block), extension));
    }

    public String getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation getBlockTexture(String path) {
        return this.modLoc("block/" + path);
    }

    public ResourceLocation getStaticBlockTexture(String path) {
        return this.markTextureAsStatic(this.getBlockTexture(path));
    }

    public ResourceLocation markTextureAsStatic(ResourceLocation texture) {
        this.staticTextures.add(texture);
        return texture;
    }

    public ResourceLocation extend(ResourceLocation resourceLocation, String suffix) {
        return new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_() + suffix);
    }
}

