/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.itemsmith;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import team.lodestar.lodestone.systems.datagen.itemsmith.AbstractItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;

public class ItemModelSmith
extends AbstractItemModelSmith {
    public final ItemModelSupplier modelSupplier;

    public ItemModelSmith(ItemModelSupplier modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    @SafeVarargs
    public final void act(AbstractItemModelSmith.ItemModelSmithData data, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            this.act(data, item);
        }
        List.of(items).forEach(data.consumer);
    }

    public void act(AbstractItemModelSmith.ItemModelSmithData data, Collection<Supplier<Item>> items) {
        items.forEach(r -> this.act(data, (Supplier<Item>)r));
        new ArrayList<Supplier<Item>>(items).forEach(data.consumer);
    }

    private void act(AbstractItemModelSmith.ItemModelSmithData data, Supplier<Item> registryObject) {
        Item item = registryObject.get();
        this.modelSupplier.act(item, data.provider);
    }

    public void act(Supplier<Item> registryObject, LodestoneItemModelProvider provider) {
        Item item = registryObject.get();
        this.modelSupplier.act(item, provider);
    }

    public static interface ItemModelSupplier {
        public void act(Item var1, LodestoneItemModelProvider var2);
    }
}

