/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.config;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import team.lodestar.lodestone.systems.config.ConfigGroup;
import team.lodestar.lodestone.systems.config.LodestoneConfig;

public class ConfigValueHolder<T> {
    private final LodestoneConfig.BuilderSupplier<T> valueSupplier;
    private ForgeConfigSpec.ConfigValue<T> config;

    public ConfigValueHolder(ConfigGroup configGroup, String path, LodestoneConfig.BuilderSupplier<T> valueSupplier) {
        this.valueSupplier = valueSupplier;
        LodestoneConfig.getConfigEntries(configGroup).computeIfAbsent(path, s -> new ArrayList()).add(this);
    }

    public void setConfig(ForgeConfigSpec.Builder builder) {
        this.config = this.valueSupplier.createBuilder(builder);
    }

    public void setConfigValue(T t) {
        this.config.set(t);
    }

    public ForgeConfigSpec.ConfigValue<T> getConfig() {
        return this.config;
    }

    public T getConfigValue() {
        return (T)this.config.get();
    }
}

