/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.block;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.ThrowawayBlockDataHandler;
import team.lodestar.lodestone.systems.block.LodestoneThrowawayBlockData;
import team.lodestar.lodestone.systems.datagen.LodestoneDatagenBlockData;

public class LodestoneBlockProperties
extends BlockBehaviour.Properties {
    public LodestoneBlockProperties(Material material, MaterialColor color) {
        super(material, state -> color);
    }

    public LodestoneBlockProperties(Material material) {
        super(material, state -> material.m_76339_());
    }

    public LodestoneBlockProperties(Material pMaterial, Function<BlockState, MaterialColor> pMaterialColor) {
        super(pMaterial, pMaterialColor);
    }

    public static LodestoneBlockProperties copy(BlockBehaviour pBlockBehaviour) {
        LodestoneBlockProperties properties = new LodestoneBlockProperties(pBlockBehaviour.f_60442_, pBlockBehaviour.f_60439_.f_60883_);
        properties.f_60882_ = pBlockBehaviour.f_60439_.f_60882_;
        properties.f_60888_ = pBlockBehaviour.f_60439_.f_60888_;
        properties.f_60887_ = pBlockBehaviour.f_60439_.f_60887_;
        properties.f_60884_ = pBlockBehaviour.f_60439_.f_60884_;
        properties.f_60890_ = pBlockBehaviour.f_60439_.f_60890_;
        properties.f_60886_ = pBlockBehaviour.f_60439_.f_60886_;
        properties.f_60883_ = pBlockBehaviour.f_60439_.f_60883_;
        properties.f_60885_ = pBlockBehaviour.f_60439_.f_60885_;
        properties.f_60891_ = pBlockBehaviour.f_60439_.f_60891_;
        properties.f_60892_ = pBlockBehaviour.f_60439_.f_60892_;
        properties.f_60903_ = pBlockBehaviour.f_60439_.f_60903_;
        properties.f_60895_ = pBlockBehaviour.f_60439_.f_60895_;
        properties.f_60896_ = pBlockBehaviour.f_60439_.f_60896_;
        properties.f_60889_ = pBlockBehaviour.f_60439_.f_60889_;
        return properties;
    }

    public LodestoneBlockProperties addThrowawayData(Function<LodestoneThrowawayBlockData, LodestoneThrowawayBlockData> function) {
        ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.put(this, function.apply(ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.getOrDefault((Object)this, new LodestoneThrowawayBlockData())));
        return this;
    }

    public LodestoneThrowawayBlockData getThrowawayData() {
        return ThrowawayBlockDataHandler.THROWAWAY_DATA_CACHE.getOrDefault((Object)this, LodestoneThrowawayBlockData.EMPTY);
    }

    public LodestoneBlockProperties setCutoutRenderType() {
        return this.setRenderType(() -> RenderType::m_110457_);
    }

    public LodestoneBlockProperties setRenderType(Supplier<Supplier<RenderType>> renderType) {
        if (FMLEnvironment.dist.isClient()) {
            this.addThrowawayData(d -> d.setRenderType(renderType));
        }
        return this;
    }

    public LodestoneBlockProperties addDatagenData(Function<LodestoneDatagenBlockData, LodestoneDatagenBlockData> function) {
        if (DatagenModLoader.isRunningDataGen()) {
            ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.put(this, function.apply(ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.getOrDefault((Object)this, new LodestoneDatagenBlockData())));
        }
        return this;
    }

    public LodestoneDatagenBlockData getDatagenData() {
        return ThrowawayBlockDataHandler.DATAGEN_DATA_CACHE.getOrDefault((Object)this, LodestoneDatagenBlockData.EMPTY);
    }

    public LodestoneBlockProperties addTag(TagKey<Block> tag) {
        this.addDatagenData(d -> d.addTag(tag));
        return this;
    }

    @SafeVarargs
    public final LodestoneBlockProperties addTags(TagKey<Block> ... tags) {
        this.addDatagenData(d -> d.addTags(tags));
        return this;
    }

    public LodestoneBlockProperties hasInheritedLoot() {
        this.addDatagenData(LodestoneDatagenBlockData::hasInheritedLoot);
        return this;
    }

    public LodestoneBlockProperties needsPickaxe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsPickaxe);
        return this;
    }

    public LodestoneBlockProperties needsAxe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsAxe);
        return this;
    }

    public LodestoneBlockProperties needsShovel() {
        this.addDatagenData(LodestoneDatagenBlockData::needsShovel);
        return this;
    }

    public LodestoneBlockProperties needsHoe() {
        this.addDatagenData(LodestoneDatagenBlockData::needsHoe);
        return this;
    }

    public LodestoneBlockProperties needsStone() {
        this.addDatagenData(LodestoneDatagenBlockData::needsStone);
        return this;
    }

    public LodestoneBlockProperties needsIron() {
        this.addDatagenData(LodestoneDatagenBlockData::needsIron);
        return this;
    }

    public LodestoneBlockProperties needsDiamond() {
        this.addDatagenData(LodestoneDatagenBlockData::needsDiamond);
        return this;
    }

    @NotNull
    public LodestoneBlockProperties noCollission() {
        return (LodestoneBlockProperties)super.m_60910_();
    }

    @NotNull
    public LodestoneBlockProperties noOcclusion() {
        return (LodestoneBlockProperties)super.m_60955_();
    }

    @NotNull
    public LodestoneBlockProperties friction(float friction) {
        return (LodestoneBlockProperties)super.m_60911_(friction);
    }

    @NotNull
    public LodestoneBlockProperties speedFactor(float factor) {
        return (LodestoneBlockProperties)super.m_60956_(factor);
    }

    @NotNull
    public LodestoneBlockProperties jumpFactor(float factor) {
        return (LodestoneBlockProperties)super.m_60967_(factor);
    }

    @NotNull
    public LodestoneBlockProperties sound(@NotNull SoundType type) {
        return (LodestoneBlockProperties)super.m_60918_(type);
    }

    @NotNull
    public LodestoneBlockProperties lightLevel(@NotNull ToIntFunction<BlockState> lightMap) {
        return (LodestoneBlockProperties)super.m_60953_(lightMap);
    }

    @NotNull
    public LodestoneBlockProperties strength(float destroyTime, float explosionResistance) {
        return (LodestoneBlockProperties)super.m_60913_(destroyTime, explosionResistance);
    }

    @NotNull
    public LodestoneBlockProperties instabreak() {
        return (LodestoneBlockProperties)super.m_60966_();
    }

    @NotNull
    public LodestoneBlockProperties strength(float strength) {
        return (LodestoneBlockProperties)super.m_60978_(strength);
    }

    @NotNull
    public LodestoneBlockProperties randomTicks() {
        return (LodestoneBlockProperties)super.m_60977_();
    }

    @NotNull
    public LodestoneBlockProperties dynamicShape() {
        return (LodestoneBlockProperties)super.m_60988_();
    }

    @NotNull
    public LodestoneBlockProperties noLootTable() {
        return (LodestoneBlockProperties)super.m_222994_();
    }

    @NotNull
    public LodestoneBlockProperties dropsLike(@NotNull Block block) {
        if (DatagenModLoader.isRunningDataGen()) {
            this.getDatagenData().hasInheritedLootTable = true;
        }
        return (LodestoneBlockProperties)super.m_60916_(block);
    }

    @NotNull
    public LodestoneBlockProperties lootFrom(@NotNull Supplier<? extends Block> blockIn) {
        this.hasInheritedLoot();
        return (LodestoneBlockProperties)super.lootFrom(blockIn);
    }

    @NotNull
    public LodestoneBlockProperties air() {
        return (LodestoneBlockProperties)super.m_60996_();
    }

    @NotNull
    public LodestoneBlockProperties isValidSpawn(@NotNull BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        return (LodestoneBlockProperties)super.m_60922_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isRedstoneConductor(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60924_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isSuffocating(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60960_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties isViewBlocking(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60971_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties hasPostProcess(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60982_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties emissiveRendering(@NotNull BlockBehaviour.StatePredicate predicate) {
        return (LodestoneBlockProperties)super.m_60991_(predicate);
    }

    @NotNull
    public LodestoneBlockProperties requiresCorrectToolForDrops() {
        return (LodestoneBlockProperties)super.m_60999_();
    }

    @NotNull
    public LodestoneBlockProperties color(@NotNull MaterialColor materialColor) {
        return (LodestoneBlockProperties)super.m_155949_(materialColor);
    }

    @NotNull
    public LodestoneBlockProperties destroyTime(float destroyTime) {
        return (LodestoneBlockProperties)super.m_155954_(destroyTime);
    }

    @NotNull
    public LodestoneBlockProperties explosionResistance(float explosionResistance) {
        return (LodestoneBlockProperties)super.m_155956_(explosionResistance);
    }
}

