/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeData;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeProvider;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class LodestoneRenderTypeRegistry
extends RenderStateShard {
    public static final HashMap<Pair<Object, RenderType>, RenderType> COPIES = new HashMap();
    public static final Function<RenderTypeData, RenderType> GENERIC = data -> LodestoneRenderTypeRegistry.createGenericRenderType(data.name, data.format, data.mode, data.shader, data.transparency, data.texture);
    public static final RenderType ADDITIVE_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "additive_particle", DefaultVertexFormat.f_85813_, LodestoneShaderRegistry.PARTICLE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, TextureAtlas.f_118260_);
    public static final RenderType ADDITIVE_BLOCK = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "block", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.LODESTONE_TEXTURE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, TextureAtlas.f_118259_);
    public static final RenderType ADDITIVE_SOLID = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "additive_solid", DefaultVertexFormat.f_85816_, RenderStateShard.f_173099_, StateShards.ADDITIVE_TRANSPARENCY);
    public static final RenderType TRANSPARENT_PARTICLE = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "transparent_particle", DefaultVertexFormat.f_85813_, LodestoneShaderRegistry.PARTICLE.getShard(), StateShards.NORMAL_TRANSPARENCY, TextureAtlas.f_118260_);
    public static final RenderType TRANSPARENT_BLOCK = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "transparent_block", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.LODESTONE_TEXTURE.getShard(), StateShards.NORMAL_TRANSPARENCY, TextureAtlas.f_118259_);
    public static final RenderType TRANSPARENT_SOLID = LodestoneRenderTypeRegistry.createGenericRenderType("lodestone", "transparent_solid", DefaultVertexFormat.f_85816_, RenderStateShard.f_173099_, StateShards.NORMAL_TRANSPARENCY);
    public static final RenderType LUMITRANSPARENT_PARTICLE = LodestoneRenderTypeRegistry.copyWithUniformChanges("lumitransparent_particle", TRANSPARENT_PARTICLE, ShaderUniformHandler.LUMITRANSPARENT);
    public static final RenderType LUMITRANSPARENT_BLOCK = LodestoneRenderTypeRegistry.copyWithUniformChanges("lumitransparent_block", TRANSPARENT_BLOCK, ShaderUniformHandler.LUMITRANSPARENT);
    public static final RenderType LUMITRANSPARENT_SOLID = LodestoneRenderTypeRegistry.copyWithUniformChanges("lumitransparent_solid", TRANSPARENT_SOLID, ShaderUniformHandler.LUMITRANSPARENT);
    public static final RenderTypeProvider TEXTURE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "texture", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.LODESTONE_TEXTURE.getShard(), StateShards.f_110134_, texture));
    public static final RenderTypeProvider TRANSPARENT_TEXTURE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "transparent_texture", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.LODESTONE_TEXTURE.getShard(), StateShards.NORMAL_TRANSPARENCY, texture));
    public static final RenderTypeProvider TRANSPARENT_TEXTURE_TRIANGLE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "transparent_texture_triangle", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.TRIANGLE_TEXTURE.getShard(), StateShards.NORMAL_TRANSPARENCY, texture));
    public static final RenderTypeProvider ADDITIVE_TEXTURE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "additive_texture", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.LODESTONE_TEXTURE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, texture));
    public static final RenderTypeProvider ADDITIVE_TEXTURE_TRIANGLE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "additive_texture_triangle", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.TRIANGLE_TEXTURE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, texture));
    public static final RenderTypeProvider SCROLLING_TEXTURE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "scrolling_texture", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.SCROLLING_TEXTURE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, texture));
    public static final RenderTypeProvider SCROLLING_TEXTURE_TRIANGLE = new RenderTypeProvider(texture -> LodestoneRenderTypeRegistry.createGenericRenderType(texture.m_135827_(), "scrolling_texture_triangle", DefaultVertexFormat.f_85820_, LodestoneShaderRegistry.SCROLLING_TRIANGLE_TEXTURE.getShard(), StateShards.ADDITIVE_TRANSPARENCY, texture));

    public LodestoneRenderTypeRegistry(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(modId, name, format, VertexFormat.Mode.QUADS, shader, transparency, RenderStateShard.f_110147_);
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(modId, name, format, mode, shader, transparency, RenderStateShard.f_110147_);
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(modId, name, format, VertexFormat.Mode.QUADS, shader, transparency, (RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(modId, name, format, mode, shader, transparency, (RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
    }

    public static RenderType createGenericRenderType(String modId, String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.EmptyTextureStateShard texture) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(modId + ":" + name, format, mode, shader, transparency, texture);
    }

    public static RenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.EmptyTextureStateShard texture) {
        return LodestoneRenderTypeRegistry.createGenericRenderType(name, format, mode, RenderType.CompositeState.m_110628_().m_173292_(shader).m_110685_(transparency).m_173290_(texture).m_110671_(f_110152_).m_110661_(f_110158_));
    }

    public static RenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderType.CompositeState.CompositeStateBuilder builder) {
        int size = RenderHandler.LARGER_BUFFER_SOURCES ? 262144 : 256;
        RenderType.CompositeRenderType type = RenderType.m_173215_((String)name, (VertexFormat)format, (VertexFormat.Mode)mode, (int)size, (boolean)false, (boolean)false, (RenderType.CompositeState)builder.m_110691_(true));
        RenderHandler.addRenderType((RenderType)type);
        return type;
    }

    public static RenderType copyWithUniformChanges(RenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(LodestoneRenderTypeRegistry.copy(type), handler);
    }

    public static RenderType copyWithUniformChanges(String newName, RenderType type, ShaderUniformHandler handler) {
        return LodestoneRenderTypeRegistry.applyUniformChanges(LodestoneRenderTypeRegistry.copy(newName, type), handler);
    }

    public static RenderType applyUniformChanges(RenderType type, ShaderUniformHandler handler) {
        RenderHandler.UNIFORM_HANDLERS.put(type, handler);
        return type;
    }

    public static RenderType copy(RenderType type) {
        return GENERIC.apply(new RenderTypeData((RenderType.CompositeRenderType)type));
    }

    public static RenderType copy(String newName, RenderType type) {
        return GENERIC.apply(new RenderTypeData(newName, (RenderType.CompositeRenderType)type));
    }

    public static RenderType copyAndStore(Object index, RenderType type) {
        return COPIES.computeIfAbsent((Pair<Object, RenderType>)Pair.of((Object)index, (Object)type), p -> GENERIC.apply(new RenderTypeData((RenderType.CompositeRenderType)type)));
    }
}

