/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DataHelper;

public class RenderHelper {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static ShaderInstance getShaderFromRenderType(RenderType type) {
        if (type instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
            Optional shader = compositeRenderType.f_110511_.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyShard(RenderType type) {
        if (type instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
            return compositeRenderType.f_110511_.f_110577_;
        }
        return null;
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }

    public static Vec2 screenSpaceQuadOffsets(Vector4f start, Vector4f end, float width) {
        float x = -start.m_123601_();
        float y = -start.m_123615_();
        if (Math.abs(start.m_123616_()) > 0.0f) {
            float ratio = end.m_123616_() / start.m_123616_();
            x = end.m_123601_() + x * ratio;
            y = end.m_123615_() + y * ratio;
        } else if (Math.abs(end.m_123616_()) <= 0.0f) {
            x += end.m_123601_();
            y += end.m_123615_();
        }
        if (start.m_123616_() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / DataHelper.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static Vector4f midpoint(Vector4f a, Vector4f b) {
        return new Vector4f((a.m_123601_() + b.m_123601_()) * 0.5f, (a.m_123615_() + b.m_123615_()) * 0.5f, (a.m_123616_() + b.m_123616_()) * 0.5f, (a.m_123617_() + b.m_123617_()) * 0.5f);
    }

    public static Vec2 worldPosToTexCoord(Vector3f worldPos, PoseStack viewModelStack) {
        Matrix4f viewMat = viewModelStack.m_85850_().m_85861_();
        Matrix4f projMat = RenderSystem.m_157192_();
        Vector3f localPos = worldPos.m_122281_();
        localPos.m_122267_(new Vector3f(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_()));
        Vector4f pos = new Vector4f(localPos);
        pos.m_123607_(viewMat);
        pos.m_123607_(projMat);
        pos.m_123621_();
        return new Vec2((pos.m_123601_() + 1.0f) / 2.0f, (pos.m_123615_() + 1.0f) / 2.0f);
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, List<Vec3> points, float lineWidth, int r, int g, int b, int a) {
        Vec3 origin = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Vec3 target = points.get(i);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawSteppedLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 start, Vec3 end, int steps, float lineWidth, int r, int g, int b, int a, Consumer<Vec3> pointConsumer) {
        Vec3 origin = start;
        for (int i = 1; i <= steps; ++i) {
            Vec3 target = start.m_82549_(end.m_82546_(start).m_82490_((double)((float)i / (float)steps)));
            pointConsumer.accept(target);
            RenderHelper.drawLineBetween(buffer, ps, origin, target, lineWidth, r, g, b, a);
            origin = target;
        }
    }

    public static void drawLineBetween(MultiBufferSource buffer, PoseStack ps, Vec3 local, Vec3 target, float lineWidth, int r, int g, int b, int a) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110475_());
        float rotY = (float)Mth.m_14136_((double)(target.f_82479_ - local.f_82479_), (double)(target.f_82481_ - local.f_82481_));
        double distX = target.f_82479_ - local.f_82479_;
        double distZ = target.f_82481_ - local.f_82481_;
        float rotX = (float)Mth.m_14136_((double)(target.f_82480_ - local.f_82480_), (double)Mth.m_14116_((float)((float)(distX * distX + distZ * distZ))));
        ps.m_85836_();
        ps.m_85837_(local.f_82479_, local.f_82480_, local.f_82481_);
        ps.m_85845_(Vector3f.f_122225_.m_122270_(rotY));
        ps.m_85845_(Vector3f.f_122222_.m_122270_(rotX));
        float distance = (float)local.m_82554_(target);
        Matrix4f matrix = ps.m_85850_().m_85861_();
        float halfWidth = lineWidth / 2.0f;
        builder.m_85982_(matrix, -halfWidth, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, halfWidth, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, halfWidth, 0.0f, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, -halfWidth, 0.0f, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, -halfWidth, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, halfWidth, 0.0f).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, halfWidth, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(matrix, 0.0f, -halfWidth, distance).m_6122_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
        ps.m_85849_();
    }
}

