/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTHelper {
    public static void saveBlockPos(CompoundTag compoundNBT, BlockPos pos) {
        compoundNBT.m_128405_("X", pos.m_123341_());
        compoundNBT.m_128405_("Y", pos.m_123342_());
        compoundNBT.m_128405_("Z", pos.m_123343_());
    }

    public static void saveBlockPos(CompoundTag compoundNBT, BlockPos pos, String extra) {
        compoundNBT.m_128405_(extra + "_X", pos.m_123341_());
        compoundNBT.m_128405_(extra + "_Y", pos.m_123342_());
        compoundNBT.m_128405_(extra + "_Z", pos.m_123343_());
    }

    public static BlockPos loadBlockPos(CompoundTag tag) {
        return tag.m_128441_("X") ? new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z")) : null;
    }

    public static BlockPos loadBlockPos(CompoundTag tag, String extra) {
        return tag.m_128441_(extra + "_X") ? new BlockPos(tag.m_128451_(extra + "_X"), tag.m_128451_(extra + "_Y"), tag.m_128451_(extra + "_Z")) : null;
    }

    public static CompoundTag filterTags(CompoundTag tag, String ... filters) {
        return NBTHelper.filterTags(tag, new HashSet<String>(Arrays.asList(filters)));
    }

    public static CompoundTag filterTags(CompoundTag tag, Set<String> filters) {
        CompoundTag newTag = new CompoundTag();
        HashSet subFilters = new HashSet();
        filters.forEach(s -> {
            while (s.contains("/")) {
                int index = s.lastIndexOf("/");
                String path = s.substring(0, index);
                subFilters.add(path);
                s = path;
            }
        });
        filters.addAll(subFilters);
        for (String filter : filters) {
            Tag entry = tag.m_128423_(filter);
            if (entry == null) continue;
            if (entry instanceof CompoundTag) {
                CompoundTag compoundEntry = (CompoundTag)entry;
                Set<String> updatedFilters = filters.stream().filter(s -> s.contains(filter + "/")).map(s -> s.substring(s.indexOf("/") + 1)).collect(Collectors.toSet());
                if (!updatedFilters.isEmpty()) {
                    entry = NBTHelper.filterTags(compoundEntry, updatedFilters);
                }
            }
            newTag.m_128365_(filter, entry);
        }
        return newTag;
    }
}

