/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers.screenparticle;

import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import team.lodestar.lodestone.config.ClientConfig;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.base.ScreenParticle;

public class ScreenParticleHandler {
    public static final HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> EARLIEST_PARTICLES = new HashMap();
    public static final HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> EARLY_PARTICLES = new HashMap();
    public static final HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> LATE_PARTICLES = new HashMap();
    public static final HashMap<Pair<Boolean, ItemStack>, HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>>> ITEM_PARTICLES = new HashMap();
    public static final HashMap<Pair<Boolean, Pair<Integer, Integer>>, ItemStack> ITEM_STACK_CACHE = new HashMap();
    public static HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> cachedItemTarget = null;
    public static int currentItemX;
    public static int currentItemY;
    public static final Tesselator TESSELATOR;
    public static boolean canSpawnParticles;
    public static boolean renderingHotbar;

    public static void tickParticles() {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        ScreenParticleHandler.tickParticles(EARLIEST_PARTICLES);
        ScreenParticleHandler.tickParticles(EARLY_PARTICLES);
        ScreenParticleHandler.tickParticles(LATE_PARTICLES);
        ITEM_PARTICLES.values().forEach(ScreenParticleHandler::tickParticles);
        ITEM_PARTICLES.values().removeIf(map -> map.values().stream().allMatch(ArrayList::isEmpty));
        canSpawnParticles = true;
    }

    public static void tickParticles(HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> screenParticleTarget) {
        screenParticleTarget.forEach((pair, particles) -> {
            Iterator iterator = particles.iterator();
            while (iterator.hasNext()) {
                ScreenParticle particle = (ScreenParticle)iterator.next();
                particle.tick();
                if (particle.isAlive()) continue;
                iterator.remove();
            }
        });
    }

    public static void renderItemStackEarly(ItemStack stack, int x, int y) {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91074_ != null) {
            if (minecraft.m_91104_()) {
                return;
            }
            if (!stack.m_41619_()) {
                currentItemX = x + 8;
                currentItemY = y + 8;
                ParticleEmitterHandler.ItemParticleSupplier emitter = ParticleEmitterHandler.EMITTERS.get(stack.m_41720_());
                if (emitter != null) {
                    HashMap target = ITEM_PARTICLES.computeIfAbsent((Pair<Boolean, ItemStack>)Pair.of((Object)renderingHotbar, (Object)stack), s -> new HashMap());
                    ScreenParticleHandler.pullFromParticleVault(stack, target);
                    if (canSpawnParticles) {
                        emitter.spawnParticles(target, (Level)minecraft.f_91073_, Minecraft.m_91087_().f_90991_.f_92518_, stack, currentItemX, currentItemY);
                    }
                    cachedItemTarget = target;
                }
            }
        }
    }

    public static void pullFromParticleVault(ItemStack currentStack, HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> target) {
        ItemStack oldStack;
        Pair cacheKey = Pair.of((Object)renderingHotbar, (Object)Pair.of((Object)currentItemX, (Object)currentItemY));
        if (ITEM_STACK_CACHE.containsKey(cacheKey) && (oldStack = ITEM_STACK_CACHE.get(cacheKey)) != currentStack && oldStack.m_41720_().equals(currentStack.m_41720_())) {
            Pair particleKey = Pair.of((Object)renderingHotbar, (Object)oldStack);
            HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> oldParticles = ITEM_PARTICLES.get(particleKey);
            if (oldParticles != null) {
                target.putAll(oldParticles);
            }
            ITEM_STACK_CACHE.remove(cacheKey);
            ITEM_PARTICLES.remove(particleKey);
        }
        ITEM_STACK_CACHE.put((Pair<Boolean, Pair<Integer, Integer>>)cacheKey, currentStack);
    }

    public static void renderItemStackLate() {
        if (cachedItemTarget != null) {
            ScreenParticleHandler.renderParticles(cachedItemTarget);
            cachedItemTarget = null;
        }
    }

    public static void renderParticles(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
                return;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null || screen instanceof ChatScreen || screen instanceof GameModeSwitcherScreen) {
                ScreenParticleHandler.renderEarliestParticles();
            }
            ScreenParticleHandler.renderLateParticles();
            canSpawnParticles = false;
        }
    }

    public static void renderEarliestParticles() {
        ScreenParticleHandler.renderParticles(EARLIEST_PARTICLES);
    }

    public static void renderEarlyParticles() {
        ScreenParticleHandler.renderParticles(EARLY_PARTICLES);
    }

    public static void renderLateParticles() {
        ScreenParticleHandler.renderParticles(LATE_PARTICLES);
    }

    private static void renderParticles(HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> screenParticleTarget) {
        if (!ClientConfig.ENABLE_SCREEN_PARTICLES.getConfigValue().booleanValue()) {
            return;
        }
        screenParticleTarget.forEach((renderType, particles) -> {
            renderType.begin(TESSELATOR.m_85915_(), Minecraft.m_91087_().f_90987_);
            for (ScreenParticle next : particles) {
                next.render(TESSELATOR.m_85915_());
            }
            renderType.end(TESSELATOR);
        });
    }

    public static void clearParticles() {
        ScreenParticleHandler.clearParticles(EARLIEST_PARTICLES);
        ScreenParticleHandler.clearParticles(EARLY_PARTICLES);
        ScreenParticleHandler.clearParticles(LATE_PARTICLES);
        ITEM_PARTICLES.values().forEach(ScreenParticleHandler::clearParticles);
    }

    public static void clearParticles(HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> screenParticleTarget) {
        screenParticleTarget.values().forEach(ArrayList::clear);
    }

    public static <T extends ScreenParticleOptions> ScreenParticle addParticle(HashMap<LodestoneScreenParticleRenderType, ArrayList<ScreenParticle>> screenParticleTarget, T options, double x, double y, double xMotion, double yMotion) {
        Minecraft minecraft = Minecraft.m_91087_();
        ScreenParticleType<?> type = options.type;
        ScreenParticle particle = type.provider.createParticle(minecraft.f_91073_, options, x, y, xMotion, yMotion);
        ArrayList list = screenParticleTarget.computeIfAbsent(options.renderType, a -> new ArrayList());
        list.add(particle);
        return particle;
    }

    static {
        TESSELATOR = new Tesselator();
    }
}

