/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.lodestar.lodestone.helpers.render.RenderHelper;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class RenderHandler {
    public static HashMap<RenderType, BufferBuilder> BUFFERS = new HashMap();
    public static HashMap<RenderType, BufferBuilder> PARTICLE_BUFFERS = new HashMap();
    public static boolean LARGER_BUFFER_SOURCES = ModList.get().isLoaded("rubidium");
    public static HashMap<RenderType, ShaderUniformHandler> UNIFORM_HANDLERS = new HashMap();
    public static MultiBufferSource.BufferSource DELAYED_RENDER;
    public static MultiBufferSource.BufferSource DELAYED_PARTICLE_RENDER;
    public static Matrix4f MATRIX4F;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static FogShape FOG_SHAPE;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;

    public static void onClientSetup(FMLClientSetupEvent event) {
        int size = LARGER_BUFFER_SOURCES ? 262144 : 256;
        DELAYED_RENDER = MultiBufferSource.m_109900_(BUFFERS, (BufferBuilder)new BufferBuilder(size));
        DELAYED_PARTICLE_RENDER = MultiBufferSource.m_109900_(PARTICLE_BUFFERS, (BufferBuilder)new BufferBuilder(size));
    }

    public static void cacheFogData(ViewportEvent.RenderFog event) {
        FOG_NEAR = event.getNearPlaneDistance();
        FOG_FAR = event.getFarPlaneDistance();
        FOG_SHAPE = event.getFogShape();
    }

    public static void cacheFogData(ViewportEvent.ComputeFogColor event) {
        FOG_RED = event.getRed();
        FOG_GREEN = event.getGreen();
        FOG_BLUE = event.getBlue();
    }

    public static void beginBufferedRendering(PoseStack poseStack) {
        poseStack.m_85836_();
        LightTexture lightTexture = Minecraft.m_91087_().f_91063_.m_109154_();
        lightTexture.m_109896_();
        RenderSystem.m_69388_((int)33986);
        RenderSystem.m_69481_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)false);
        float fogRed = RenderSystem.m_157198_()[0];
        float fogGreen = RenderSystem.m_157198_()[1];
        float fogBlue = RenderSystem.m_157198_()[2];
        float shaderFogStart = RenderSystem.m_157200_();
        float shaderFogEnd = RenderSystem.m_157199_();
        FogShape shaderFogShape = RenderSystem.m_202041_();
        RenderSystem.m_157445_((float)FOG_NEAR);
        RenderSystem.m_157443_((float)FOG_FAR);
        RenderSystem.m_202160_((FogShape)FOG_SHAPE);
        RenderSystem.m_157434_((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void renderBufferedParticles(boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(DELAYED_PARTICLE_RENDER, PARTICLE_BUFFERS, transparentOnly);
    }

    public static void renderBufferedBatches(boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(DELAYED_RENDER, BUFFERS, transparentOnly);
    }

    private static void renderBufferedBatches(MultiBufferSource.BufferSource bufferSource, HashMap<RenderType, BufferBuilder> buffer, boolean transparentOnly) {
        ArrayList<RenderType> transparentRenderTypes = new ArrayList<RenderType>();
        for (RenderType renderType : buffer.keySet()) {
            RenderStateShard.TransparencyStateShard transparency = RenderHelper.getTransparencyShard(renderType);
            if (!transparency.equals(StateShards.NORMAL_TRANSPARENCY)) continue;
            transparentRenderTypes.add(renderType);
        }
        if (transparentOnly) {
            RenderHandler.endBatches(bufferSource, transparentRenderTypes);
        } else {
            ArrayList<RenderType> nonTransparentRenderTypes = new ArrayList<RenderType>(buffer.keySet());
            nonTransparentRenderTypes.removeIf(transparentRenderTypes::contains);
            RenderHandler.endBatches(bufferSource, nonTransparentRenderTypes);
        }
    }

    public static void endBufferedRendering(PoseStack poseStack) {
        LightTexture lightTexture = Minecraft.m_91087_().f_91063_.m_109154_();
        RenderSystem.m_157445_((float)FOG_NEAR);
        RenderSystem.m_157443_((float)FOG_FAR);
        RenderSystem.m_202160_((FogShape)FOG_SHAPE);
        RenderSystem.m_157434_((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        poseStack.m_85849_();
        lightTexture.m_109891_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)true);
    }

    public static void endBatches(MultiBufferSource.BufferSource source, Collection<RenderType> renderTypes) {
        for (RenderType type : renderTypes) {
            ShaderInstance instance = RenderHelper.getShaderFromRenderType(type);
            if (UNIFORM_HANDLERS.containsKey(type)) {
                ShaderUniformHandler handler = UNIFORM_HANDLERS.get(type);
                handler.updateShaderData(instance);
            }
            source.m_109912_(type);
            if (!(instance instanceof ExtendedShaderInstance)) continue;
            ExtendedShaderInstance extendedShaderInstance = (ExtendedShaderInstance)instance;
            extendedShaderInstance.setUniformDefaults();
        }
    }

    public static void addRenderType(RenderType type) {
        int size = LARGER_BUFFER_SOURCES ? 262144 : type.m_110507_();
        HashMap<RenderType, BufferBuilder> buffers = BUFFERS;
        if (type.f_110133_.contains("particle")) {
            buffers = PARTICLE_BUFFERS;
        }
        buffers.put(type, new BufferBuilder(size));
    }
}

