/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.placementassistance.IPlacementAssistant;

public class PlacementAssistantHandler {
    public static final ArrayList<IPlacementAssistant> ASSISTANTS = new ArrayList();
    public static int animationTick = 0;
    public static BlockHitResult target;

    public static void registerPlacementAssistants(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DataHelper.getAll(new ArrayList(ForgeRegistries.BLOCKS.getValues()), b -> b instanceof IPlacementAssistant).forEach(i -> {
            IPlacementAssistant assistant = (IPlacementAssistant)i;
            ASSISTANTS.add(assistant);
        }));
    }

    public static void placeBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.f_19853_;
        if (level.f_46443_) {
            List<Pair<IPlacementAssistant, ItemStack>> assistants = PlacementAssistantHandler.findAssistants(level, player, (HitResult)event.getHitVec());
            for (Pair<IPlacementAssistant, ItemStack> pair : assistants) {
                IPlacementAssistant assistant = (IPlacementAssistant)pair.getFirst();
                BlockState state = level.m_8055_(event.getPos());
                assistant.onPlaceBlock(player, level, event.getHitVec(), state, (ItemStack)pair.getSecond());
            }
            animationTick = Math.max(0, animationTick - 5);
        }
    }

    public static void tick(Player player, HitResult hitResult) {
        BlockHitResult blockHitResult;
        Level level = player.f_19853_;
        List<Pair<IPlacementAssistant, ItemStack>> placementAssistants = PlacementAssistantHandler.findAssistants(level, player, hitResult);
        for (Pair<IPlacementAssistant, ItemStack> pair : placementAssistants) {
            IPlacementAssistant assistant = (IPlacementAssistant)pair.getFirst();
            assistant.onHoldValidItem(player, level, (ItemStack)pair.getSecond());
        }
        if (hitResult instanceof BlockHitResult && !(blockHitResult = (BlockHitResult)hitResult).m_6662_().equals((Object)HitResult.Type.MISS)) {
            target = blockHitResult;
            for (Pair<IPlacementAssistant, ItemStack> pair : placementAssistants) {
                IPlacementAssistant assistant = (IPlacementAssistant)pair.getFirst();
                BlockState state = level.m_8055_(blockHitResult.m_82425_());
                assistant.onObserveBlock(player, level, blockHitResult, state, (ItemStack)pair.getSecond());
            }
        } else {
            target = null;
        }
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static List<Pair<IPlacementAssistant, ItemStack>> findAssistants(Level level, Player player, HitResult hitResult) {
        if (!(hitResult instanceof BlockHitResult)) {
            return Collections.emptyList();
        }
        return PlacementAssistantHandler.findAssistants(level, player);
    }

    private static List<Pair<IPlacementAssistant, ItemStack>> findAssistants(Level level, Player player) {
        if (level == null || player == null || player.m_6144_()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<IPlacementAssistant, ItemStack>> matchingAssistants = new ArrayList<Pair<IPlacementAssistant, ItemStack>>();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.m_21120_(hand);
            matchingAssistants.addAll(ASSISTANTS.stream().filter(s -> s.canAssist().test(held)).map(a -> Pair.of((Object)a, (Object)held)).collect(Collectors.toCollection(ArrayList::new)));
        }
        return matchingAssistants;
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }
}

