/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.capability.LodestonePlayerDataCapability;
import team.lodestar.lodestone.handlers.GhostBlockHandler;
import team.lodestar.lodestone.handlers.PlacementAssistantHandler;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.handlers.ScreenshakeHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.systems.client.ClientTickCounter;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientRuntimeEvents {
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                ClientTickCounter.clientTick();
                if (minecraft.m_91104_()) {
                    return;
                }
                Camera camera = minecraft.f_91063_.m_109153_();
                GhostBlockHandler.tickGhosts();
                WorldEventHandler.tick((Level)minecraft.f_91073_);
                PlacementAssistantHandler.tick((Player)minecraft.f_91074_, minecraft.f_91077_);
                ScreenshakeHandler.clientTick(camera, LodestoneLib.RANDOM);
                LodestonePlayerDataCapability.ClientOnly.clientTick(event);
                ScreenParticleHandler.tickParticles();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderFog(ViewportEvent.RenderFog event) {
        RenderHandler.cacheFogData(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void fogColors(ViewportEvent.ComputeFogColor event) {
        RenderHandler.cacheFogData(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderStages(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        float partial = event.getPartialTick();
        PoseStack poseStack = event.getPoseStack();
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY)) {
            GhostBlockHandler.renderGhosts(poseStack);
            WorldEventHandler.ClientOnly.renderWorldEvents(poseStack, partial);
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            RenderHandler.MATRIX4F = RenderSystem.m_157190_().m_27658_();
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            Matrix4f last = RenderSystem.m_157190_().m_27658_();
            if (levelRenderer.f_109418_ != null) {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
            }
            RenderHandler.beginBufferedRendering(poseStack);
            RenderHandler.renderBufferedParticles(true);
            if (RenderHandler.MATRIX4F != null) {
                RenderSystem.m_157190_().m_162210_(RenderHandler.MATRIX4F);
            }
            RenderHandler.renderBufferedBatches(true);
            RenderHandler.renderBufferedBatches(false);
            RenderSystem.m_157190_().m_162210_(last);
            RenderHandler.renderBufferedParticles(false);
            RenderHandler.endBufferedRendering(poseStack);
            if (levelRenderer.f_109418_ != null) {
                levelRenderer.m_109832_().m_83947_(false);
            }
        }
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        ScreenParticleHandler.renderParticles(event);
        ClientTickCounter.renderTick(event);
    }
}

