/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IEInputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class IERecipeJS
extends RecipeJS {
    public JsonElement writeInputItem(InputItem value) {
        if (value.count > 1) {
            JsonObject json = new JsonObject();
            json.add("base_ingredient", value.ingredient.m_43942_());
            json.addProperty("count", (Number)value.count);
            return json;
        }
        return value.ingredient.m_43942_();
    }

    public InputItem readInputItem(Object from) {
        try {
            JsonObject j;
            if (from instanceof JsonObject && (j = (JsonObject)from).has("base_ingredient")) {
                int c = GsonHelper.m_13824_((JsonObject)j, (String)"count", (int)1);
                return IngredientJS.of((Object)j.get("base_ingredient")).kjs$withCount(c);
            }
            return super.readInputItem(from);
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.error("[%s] Failed to read IE input item from %s".formatted(this.type.id, from), (Throwable)ex, RecipesEventJS.SKIP_ERROR);
            return InputItem.EMPTY;
        }
    }

    public OutputItem readOutputItem(Object from) {
        try {
            JsonObject j;
            if (from instanceof JsonObject && !(j = (JsonObject)from).has("item")) {
                return OutputItem.of((Object)IEApi.getPreferredStackbyMod((ItemStack[])IngredientWithSize.deserialize((JsonElement)j).getMatchingStacks()));
            }
            return super.readOutputItem(from);
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.error("[%s] Failed to read IE output item from %s".formatted(this.type.id, from), (Throwable)ex, RecipesEventJS.SKIP_ERROR);
            return OutputItem.EMPTY;
        }
    }

    public InputFluid readInputFluid(Object from) {
        CharSequence c;
        if (from instanceof IEInputFluid) {
            IEInputFluid in = (IEInputFluid)from;
            return in;
        }
        if (from instanceof FluidTagInput) {
            FluidTagInput tag = (FluidTagInput)from;
            return new IEInputFluid(tag);
        }
        if (from instanceof CharSequence && (c = (CharSequence)from).charAt(0) == '#') {
            TagKey tag = Tags.fluid((ResourceLocation)new ResourceLocation(c.subSequence(1, c.length()).toString()));
            return new IEInputFluid(new FluidTagInput(tag, 1000));
        }
        if (from instanceof Map || from instanceof JsonObject) {
            JsonObject json = MapJS.json((Object)from);
            if (json.has("fluid")) {
                throw new RecipeExceptionJS("Invalid key 'fluid' in IE input fluid json %s! Note that Immersive Engineering only accepts fluid tags as inputs!".formatted(from));
            }
            try {
                return new IEInputFluid(FluidTagInput.deserialize((JsonElement)json));
            }
            catch (JsonParseException ex) {
                throw new RecipeExceptionJS("Failed to deserialize IE input fluid json!", (Throwable)ex);
            }
        }
        throw new RecipeExceptionJS("[%s] Failed to read IE input fluid from %s! Note that Immersive Engineering only accepts fluid tags as inputs!".formatted(this.type.id, from));
    }

    public JsonElement writeInputFluid(InputFluid value) {
        if (value instanceof IEInputFluid) {
            IEInputFluid in = (IEInputFluid)value;
            return in.input().serialize();
        }
        throw new RecipeExceptionJS("[%s] Failed to write IE input fluid from %s! Note that Immersive Engineering only accepts fluid tags as inputs!".formatted(this.type.id, value));
    }
}

