/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;

public class DoubleTallPlantRecollectable
extends PlantRecollectable {
    public DoubleTallPlantRecollectable() {
        super("blocksugarandcactus");
    }

    @Override
    public boolean canBeHarvested(Level world, BlockPos pos, BlockState blockState) {
        return blockState.m_60734_() instanceof CactusBlock && world.m_8055_(pos.m_7494_()).m_60734_() instanceof CactusBlock || blockState.m_60734_() instanceof SugarCaneBlock && world.m_8055_(pos.m_7494_()).m_60734_() instanceof SugarCaneBlock;
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState) {
        NonNullList stacks = NonNullList.m_122779_();
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.m_5484_(Direction.UP, 2));
        this.harvestBlock((NonNullList<ItemStack>)stacks, world, pos.m_5484_(Direction.UP, 1));
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(Level world, BlockPos pos, BlockState blockState) {
        return true;
    }

    private void harvestBlock(NonNullList<ItemStack> stacks, Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60734_() instanceof CactusBlock || blockState.m_60734_() instanceof SugarCaneBlock) {
            stacks.addAll(BlockUtils.getBlockDrops(world, pos));
            if (!world.m_6425_(pos).m_76178_()) {
                world.m_46597_(pos, Blocks.f_49990_.m_49966_());
            } else {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.sugar_cane", "text.industrialforegoing.plant.cactus");
    }
}

