/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TransporterWorldType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    private int extractSlot = 0;

    public TransporterWorldType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new RegulatorFilter<ItemStack, IItemHandler>(20, 20, 5, 3, 16, 64, 8192, ""){

            @Override
            public int matches(ItemStack stack, IItemHandler itemHandler, boolean isRegulated) {
                if (this.isEmpty()) {
                    return stack.m_41613_();
                }
                int amount = 0;
                if (isRegulated) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!itemHandler.getStackInSlot(i).m_41656_(stack)) continue;
                        amount += itemHandler.getStackInSlot(i).m_41613_();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    if (!stack.m_41656_(slot.getStack())) continue;
                    int maxAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.m_41613_(), maxAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getLevel().f_46443_ && (float)this.getLevel().m_46467_() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().m_122424_()).ifPresent(origin -> {
                    if (origin.getSlots() <= 0) {
                        return;
                    }
                    if (origin.getStackInSlot(this.extractSlot).m_41619_() || !this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        this.findSlot((IItemHandler)origin);
                    }
                    if (!origin.getStackInSlot(this.extractSlot).m_41619_() && this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        int amount = (int)(1.0f * this.getEfficiency());
                        ItemStack extracted = origin.extractItem(this.extractSlot, amount, false);
                        if (extracted.m_41619_()) {
                            return;
                        }
                        ItemEntity item = new ItemEntity(this.getLevel(), (double)this.getPos().m_123341_() + 0.5, (double)this.getPos().m_123342_() + 0.2, (double)this.getPos().m_123343_() + 0.5, extracted);
                        item.m_20334_(0.0, 0.0, 0.0);
                        item.m_32010_(4);
                        item.m_32045_(extracted);
                        this.getLevel().m_7967_((Entity)item);
                    }
                }));
            }
            if (this.getAction() == TransporterTypeFactory.TransporterAction.INSERT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().m_122424_()).ifPresent(origin -> {
                    for (ItemEntity item : this.getLevel().m_45976_(ItemEntity.class, new AABB((double)this.getPos().m_123341_(), (double)this.getPos().m_123342_(), (double)this.getPos().m_123343_(), (double)(this.getPos().m_123341_() + 1), (double)(this.getPos().m_123342_() + 1), (double)(this.getPos().m_123343_() + 1)))) {
                        int i;
                        if (!item.m_6084_()) continue;
                        ItemStack stack = item.m_32055_().m_41777_();
                        int amount = Math.min(stack.m_41613_(), (int)(1.0f * this.getEfficiency()));
                        stack.m_41764_(amount);
                        amount = this.getFilter().matches(stack, (IItemHandler)origin, this.isRegulated());
                        if (amount <= 0) continue;
                        stack.m_41764_(amount);
                        if (stack.m_41619_() || !this.filter(this.getFilter(), this.isWhitelist(), stack, (IItemHandler)origin, this.isRegulated()) || (i = 0) >= origin.getSlots()) continue;
                        stack = origin.insertItem(i, stack, false);
                        ItemStack originStack = item.m_32055_().m_41777_();
                        originStack.m_41774_(amount - stack.m_41613_());
                        if (originStack.m_41619_()) {
                            item.m_32045_(ItemStack.f_41583_);
                            item.m_142687_(Entity.RemovalReason.KILLED);
                            return;
                        }
                        item.m_32045_(originStack);
                        return;
                    }
                }));
            }
        }
    }

    private void findSlot(IItemHandler itemHandler) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).m_41619_() || !this.filter(this.getFilter(), this.isWhitelist(), itemHandler.getStackInSlot(i), itemHandler, false)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    private boolean filter(RegulatorFilter<ItemStack, IItemHandler> filter, boolean whitelist, ItemStack stack, IItemHandler handler, boolean isRegulated) {
        int accepts = filter.matches(stack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame);
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            super("world");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterWorldType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:blocks/transporters/world"), new ResourceLocation("industrialforegoing:blocks/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((BlockGetter)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.m_7912_().toLowerCase());
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).m_126130_("IPI").m_126130_("GMG").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42584_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42162_).m_176498_(consumer);
        }
    }
}

