/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.biome;

import net.joefoxe.hexerei.world.gen.ModConfiguredFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"hexerei");
    public static final RegistryObject<Biome> WILLOW_SWAMP = BIOMES.register("willow_swamp", ModBiomes::makeWillowSwampBiome);

    public static Biome makeWillowSwampBiome() {
        MobSpawnSettings.Builder mobSpawnSettingsBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)mobSpawnSettingsBuilder);
        mobSpawnSettingsBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        mobSpawnSettingsBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder genSettingsBuilder = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        ModBiomes.globalOverworldGeneration(genSettingsBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.m_126840_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195412_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195413_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        BiomeDefaultFeatures.m_198933_((BiomeGenerationSettings.Builder)genSettingsBuilder);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195248_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195245_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195244_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195249_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195250_);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.COMMON_SWAMP_FLOWERS);
        genSettingsBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.TREES_WILLOW_SWAMP);
        BiomeSpecialEffects.Builder specialEffectsBuilder = new BiomeSpecialEffects.Builder();
        specialEffectsBuilder.m_48034_(6388580).m_48037_(2302743).m_48019_(12638463).m_48040_(ModBiomes.getSkyColorWithTemperatureModifier(0.8f)).m_48043_(6975545).m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48027_(AmbientMoodSettings.f_47387_);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47603_(specialEffectsBuilder.m_48018_()).m_47605_(mobSpawnSettingsBuilder.m_48381_()).m_47601_(genSettingsBuilder.m_47831_()).m_47592_();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = Mth.m_14036_((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    public static void register(IEventBus eventBus) {
        BIOMES.register(eventBus);
    }
}

