/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CandleEffectParticlePacket {
    BlockPos pos;
    List<ResourceLocation> particleLocations;
    int livingId;
    int stage;

    public CandleEffectParticlePacket(BlockPos pos, List<ResourceLocation> particleLocations, int livingId, int stage) {
        this.pos = pos;
        this.particleLocations = particleLocations;
        this.livingId = livingId;
        this.stage = stage;
    }

    public static void encode(CandleEffectParticlePacket object, FriendlyByteBuf buffer) {
        buffer.m_130064_(object.pos);
        buffer.writeInt(object.particleLocations.size());
        for (int i = 0; i < object.particleLocations.size(); ++i) {
            buffer.m_130085_(object.particleLocations.get(i));
        }
        buffer.writeInt(object.livingId);
        buffer.writeInt(object.stage);
    }

    public static CandleEffectParticlePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int size = buffer.readInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            list.add(buffer.m_130281_());
        }
        return new CandleEffectParticlePacket(pos, list, buffer.readInt(), buffer.readInt());
    }

    public static void consume(CandleEffectParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            if (world.m_7702_(packet.pos) != null && (blockEntity = world.m_7702_(packet.pos)) instanceof CandleTile) {
                Entity patt2846$temp;
                CandleTile candleTile = (CandleTile)blockEntity;
                Random random = new Random();
                if (packet.stage == 0 && (patt2846$temp = world.m_6815_(packet.livingId)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)patt2846$temp;
                    PotionCandleEffect.spawnParticles(world, packet.particleLocations, livingEntity);
                }
                if (packet.stage == 1) {
                    Candle.spawnParticleWave(world, packet.pos, true, packet.particleLocations, 20);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

