/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.MoonPhases;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.fluid.PotionMixingRecipes;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.EmitParticlesPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MixingCauldronTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider,
IFluidHandler {
    public boolean crafting;
    public int craftDelay;
    public int craftDelayOld;
    public int emitParticles = 0;
    public boolean emitParticleSpout = false;
    public float degrees;
    private boolean crafted;
    private boolean extracted = false;
    private int isColliding = 0;
    public static final int craftDelayMax = 100;
    private long tickedGameTime;
    public int dyeColor = 4337438;
    public Component customName;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
    private FluidStack fluidStack = FluidStack.EMPTY;
    private static final int[] SLOTS_INPUT = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] SLOTS_OUTPUT = new int[]{8};
    VoxelShape BLOOD_SIGIL_SHAPE = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    VoxelShape HOPPER_SHAPE = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public float fluidRenderLevel = 0.0f;
    public FluidStack renderedFluid;
    boolean checkCraft = true;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public MixingCauldronTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public MixingCauldronTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.MIXING_CAULDRON_TILE.get(), blockPos, blockState);
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : Component.m_237113_((String)"");
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public void setDyeColor(int dyeColor) {
        this.dyeColor = dyeColor;
    }

    public int getDyeColor() {
        DyeColor dye = HexereiUtil.getDyeColorNamed(this.m_5446_().getString());
        if (dye != null) {
            return HexereiUtil.getColorValue(dye);
        }
        return this.dyeColor;
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkCraft = true;
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.getPos(), this.f_58857_.m_8055_(this.getPos()), this.f_58857_.m_8055_(this.getPos()), 2);
            }
        }
    }

    public int m_6893_() {
        return 1;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.mixing_cauldron");
    }

    public void setContents(List<ItemStack> stacks, Player player) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (i >= 8 && stacks.get(i).m_41619_() || ((ItemStack)this.items.get(i)).m_41726_(stacks.get(i))) continue;
            int slot = player.f_36093_.m_36030_(stacks.get(i));
            ItemStack stack = ContainerHelper.m_18969_((List)player.f_36093_.f_35974_, (int)slot, (int)1);
            player.f_36093_.m_150079_((ItemStack)this.items.get(i));
            this.items.set(i, (Object)stack);
        }
        this.m_6596_();
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (itemStack.m_41613_() < 1) {
            itemStack.m_41764_(1);
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            this.items.set(index, (Object)itemStack);
        }
        this.m_6596_();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 8) {
            return false;
        }
        if (index == 9 && !stack.m_204117_(HexereiTags.Items.SIGILS)) {
            return false;
        }
        return ((ItemStack)this.items.get(index)).m_41619_();
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_OUTPUT;
        }
        return SLOTS_INPUT;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getCraftDelay() {
        return this.craftDelay;
    }

    public void setCraftDelay(int delay) {
        this.craftDelay = delay;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new MixingCauldronContainer(id, this.f_58857_, this.getPos(), player, player.f_35978_);
    }

    public void m_6211_() {
        super.m_6211_();
        this.items.clear();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        return super.getModelData();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)compoundTag.m_128469_("fluid"));
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
        if (compoundTag.m_128441_("DyeColor")) {
            this.dyeColor = compoundTag.m_128451_("DyeColor");
        }
        if (compoundTag.m_128441_("delay")) {
            this.craftDelay = compoundTag.m_128451_("delay");
        }
        if (compoundTag.m_128441_("delayOld")) {
            this.craftDelayOld = compoundTag.m_128451_("delayOld");
        }
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128365_("fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        compound.m_128405_("delay", this.craftDelay);
        compound.m_128405_("delayOld", this.craftDelayOld);
        compound.m_128405_("DyeColor", this.dyeColor);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128365_("fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        tag.m_128405_("delay", this.craftDelay);
        tag.m_128405_("delayOld", this.craftDelayOld);
        tag.m_128405_("DyeColor", this.dyeColor);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return tag;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.extracted && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return ForgeCapabilities.FLUID_HANDLER.orEmpty(capability, LazyOptional.of(() -> this));
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).m_41720_();
    }

    public ItemStack getItemStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public int getCraftMaxDelay() {
        return 100;
    }

    public boolean getCrafted() {
        return this.crafted;
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    private void strikeLightning() {
        if (!this.f_58857_.m_5776_()) {
            EntityType.f_20465_.m_20592_((ServerLevel)this.f_58857_, null, null, this.f_58858_, MobSpawnType.TRIGGERED, true, true);
        }
    }

    public void entityInside(Entity entity) {
        BlockPos blockpos = this.getPos();
        if (entity instanceof ItemEntity) {
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)this.HOPPER_SHAPE, (BooleanOp)BooleanOp.f_82689_) && this.captureItem((ItemEntity)entity) && !this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_, 2, true));
            }
        } else if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)this.BLOOD_SIGIL_SHAPE, (BooleanOp)BooleanOp.f_82689_)) {
            if (this.isColliding <= 1 && this.getItemInSlot(9).m_5456_() == ModItems.BLOOD_SIGIL.get()) {
                Random random = new Random();
                entity.m_6469_(DamageSource.f_19319_, 3.0f);
                if (this.fluidStack.isEmpty() || this.fluidStack.containsFluid(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 1)) && this.getFluidStack().getAmount() < this.getTankCapacity(0)) {
                    if (this.fluidStack.isEmpty()) {
                        this.fill(new FluidStack((Fluid)ModFluids.BLOOD_FLUID.get(), 111), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        this.getFluidStack().grow(111);
                        if (this.getFluidStack().getAmount() % 1000 == 1) {
                            this.getFluidStack().shrink(1);
                        }
                        if (this.getFluidStack().getAmount() % 1000 == 999) {
                            this.getFluidStack().grow(1);
                        }
                        this.m_6596_();
                    }
                    entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11970_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!this.f_58857_.f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_, 2, true));
                    }
                }
            }
            this.isColliding = 6;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public boolean captureItem(ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack itemstack = itemEntity.m_32055_().m_41777_();
        if (this.getFirstOpenSlot() >= 0) {
            ItemStack temp = itemstack.m_41777_();
            temp.m_41764_(1);
            this.m_6836_(this.getFirstOpenSlot(), temp);
            itemEntity.m_32055_().m_41774_(1);
            return true;
        }
        return false;
    }

    public int getFirstOpenSlot() {
        for (int i = 0; i < 8; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void craft() {
        this.crafting = false;
        SimpleContainer inv = new SimpleContainer(10);
        for (int i = 0; i < 9; ++i) {
            inv.m_6836_(i, (ItemStack)this.items.get(i));
        }
        if (PotionMixingRecipes.ALL == null || PotionMixingRecipes.ALL.isEmpty()) {
            PotionMixingRecipes.ALL = PotionMixingRecipes.createRecipes();
            PotionMixingRecipes.BY_ITEM = PotionMixingRecipes.sortRecipesByItem(PotionMixingRecipes.ALL);
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MixingCauldronRecipe.Type.INSTANCE, (Container)inv, this.f_58857_);
        List<FluidMixingRecipe> recipe2 = PotionMixingRecipes.ALL.stream().filter(potionRecipe -> {
            if (potionRecipe.m_7527_().isEmpty()) {
                PotionMixingRecipes.ALL = null;
                return false;
            }
            return potionRecipe.matches(inv, this.f_58857_);
        }).toList();
        boolean matchesRecipe = false;
        ResourceLocation fl2 = ForgeRegistries.FLUIDS.getKey((Object)this.fluidStack.getFluid());
        CompoundTag tag = this.fluidStack.isEmpty() ? new CompoundTag() : this.fluidStack.copy().getOrCreateTag();
        for (FluidMixingRecipe fluidMixingRecipe : recipe2) {
            boolean flag;
            boolean fluidEqual = fluidMixingRecipe.getLiquid().isFluidEqual(this.fluidStack);
            ResourceLocation fl1 = ForgeRegistries.FLUIDS.getKey((Object)fluidMixingRecipe.getLiquid().getFluid());
            if (!fluidEqual && fl1 != null && fl2 != null && fl1.m_135815_().equals(fl2.m_135815_()) && (flag = NbtUtils.m_129235_((Tag)fluidMixingRecipe.getLiquid().copy().getOrCreateTag(), (Tag)tag, (boolean)true))) {
                fluidEqual = true;
            }
            if (!fluidEqual) continue;
            matchesRecipe = true;
            break;
        }
        if (!matchesRecipe) {
            recipe2 = this.f_58857_.m_7465_().m_44015_((RecipeType)FluidMixingRecipe.Type.INSTANCE, (Container)inv, this.f_58857_).stream().toList();
        }
        AtomicBoolean firstRecipe = new AtomicBoolean(false);
        recipe.ifPresent(iRecipe -> {
            boolean needsMoonPhase;
            ItemStack output = iRecipe.m_8043_();
            FluidStack recipeFluid = iRecipe.getLiquid();
            FluidStack containerFluid = this.getFluidStack();
            boolean fluidEqual = recipeFluid.isFluidEqual(containerFluid);
            boolean outputClear = inv.m_8020_(8) == ItemStack.f_41583_ || inv.m_8020_(8).m_41613_() == 0 || inv.m_8020_(8).m_41656_(output) && inv.m_8020_(8).m_41613_() + output.m_41613_() <= inv.m_8020_(8).m_41741_();
            boolean hasEnoughFluid = iRecipe.getFluidLevelsConsumed() <= this.getFluidStack().getAmount();
            boolean needsHeat = iRecipe.getHeatCondition() != FluidMixingRecipe.HeatCondition.NONE;
            boolean bl = needsMoonPhase = iRecipe.getMoonCondition() != MoonPhases.MoonCondition.NONE;
            if ((!needsMoonPhase || MoonPhases.MoonCondition.getMoonPhase(this.f_58857_) == iRecipe.getMoonCondition()) && fluidEqual && !this.crafted && hasEnoughFluid && outputClear) {
                BlockState heatSource = this.f_58857_.m_8055_(this.getPos().m_7495_());
                if (!(needsHeat && !heatSource.m_204336_(HexereiTags.Blocks.HEAT_SOURCES) || heatSource.m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)heatSource.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue())) {
                    firstRecipe.set(true);
                    this.crafting = true;
                    if (this.craftDelay >= 100) {
                        this.craftTheItem(output);
                        int temp = this.getFluidStack().getAmount();
                        this.getFluidStack().shrink(this.getTankCapacity(0));
                        this.fill(new FluidStack(iRecipe.getLiquidOutput(), temp), IFluidHandler.FluidAction.EXECUTE);
                        this.crafted = true;
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_, 10, true));
                        this.getFluidStack().shrink(iRecipe.getFluidLevelsConsumed());
                        if (this.getFluidStack().getAmount() % 10 == 1) {
                            this.getFluidStack().shrink(1);
                        }
                        if (this.getFluidStack().getAmount() % 10 == 9) {
                            this.getFluidStack().grow(1);
                        }
                        this.m_6596_();
                    }
                }
            }
        });
        if (!firstRecipe.get() && !recipe2.isEmpty()) {
            for (FluidMixingRecipe fluidMixingRecipe : recipe2) {
                boolean needsHeat;
                boolean flag;
                ItemStack output = fluidMixingRecipe.m_8043_();
                FluidStack recipeFluid = fluidMixingRecipe.getLiquid();
                FluidStack containerFluid = this.getFluidStack();
                boolean fluidEqual = recipeFluid.isFluidEqual(containerFluid);
                ResourceLocation fl1 = ForgeRegistries.FLUIDS.getKey((Object)fluidMixingRecipe.getLiquid().getFluid());
                if (!fluidEqual && fl1 != null && fl2 != null && fl1.m_135815_().equals(fl2.m_135815_()) && (flag = NbtUtils.m_129235_((Tag)fluidMixingRecipe.getLiquid().copy().getOrCreateTag(), (Tag)tag, (boolean)true))) {
                    fluidEqual = true;
                }
                boolean hasEnoughFluid = this.getFluidStack().getAmount() >= 50;
                boolean bl = needsHeat = fluidMixingRecipe.getHeatCondition() != FluidMixingRecipe.HeatCondition.NONE;
                if (!fluidEqual || this.crafted || !hasEnoughFluid) continue;
                BlockState heatSource = this.f_58857_.m_8055_(this.getPos().m_7495_());
                if (needsHeat && !heatSource.m_204336_(HexereiTags.Blocks.HEAT_SOURCES) || heatSource.m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)heatSource.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) continue;
                this.crafting = true;
                if (this.craftDelay < 100) continue;
                this.craftTheItem(output);
                int temp = this.getFluidStack().getAmount();
                this.getFluidStack().shrink(this.getTankCapacity(0));
                this.fill(new FluidStack(fluidMixingRecipe.getLiquidOutput(), temp), IFluidHandler.FluidAction.EXECUTE);
                this.crafted = true;
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new EmitParticlesPacket(this.f_58858_, 10, true));
                this.m_6596_();
            }
        }
    }

    private void craftTheItem(ItemStack output) {
        Random random;
        if (output.m_41720_() == ModItems.TALLOW_IMPURITY.get() && (random = new Random()).nextInt(5) != 0) {
            output = ItemStack.f_41583_;
        }
        this.m_6836_(0, ItemStack.f_41583_);
        this.m_6836_(1, ItemStack.f_41583_);
        this.m_6836_(2, ItemStack.f_41583_);
        this.m_6836_(3, ItemStack.f_41583_);
        this.m_6836_(4, ItemStack.f_41583_);
        this.m_6836_(5, ItemStack.f_41583_);
        this.m_6836_(6, ItemStack.f_41583_);
        this.m_6836_(7, ItemStack.f_41583_);
        if (this.m_8020_(8).m_41656_(output)) {
            this.m_8020_(8).m_41764_(this.m_8020_(8).m_41613_() + output.m_41613_());
        } else {
            this.m_6836_(8, output);
        }
    }

    public void tick() {
        this.craftDelayOld = this.craftDelay;
        if (this.f_58857_.f_46443_) {
            float dist = Math.abs(this.fluidRenderLevel - (float)this.fluidStack.getAmount()) / 1000.0f;
            if (!this.fluidStack.isEmpty()) {
                this.renderedFluid = this.fluidStack.copy();
            }
            if (this.renderedFluid != null) {
                this.renderedFluid.setAmount((int)this.fluidRenderLevel);
            }
            this.renderParticles();
            return;
        }
        this.tickedGameTime = this.f_58857_.m_46467_();
        if (this.checkCraft) {
            this.craft();
            this.checkCraft = false;
        }
        if (this.crafting) {
            this.craftDelay += 2;
        }
        if (this.craftDelay >= 1) {
            --this.craftDelay;
        }
        if (this.craftDelay > 0 && !this.f_58857_.f_46443_) {
            this.sync();
        }
        if (this.craftDelay > 100) {
            this.craft();
        }
        if (this.craftDelay < 10 && this.crafted) {
            this.checkCraft = true;
            this.crafted = false;
        }
        if (this.extracted) {
            this.extracted = false;
            this.m_6596_();
        }
        --this.isColliding;
    }

    private void renderParticles() {
        float fillPercentage = 0.0f;
        FluidStack fluidStack = this.getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)this.getTankCapacity(0));
        }
        float height = 0.25f + 0.6875f * fillPercentage;
        Random rand = new Random();
        if (this.emitParticles > 0 && this.f_58857_ != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.emitParticleSpout) {
                    if (rand.nextInt(3) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_58857_.m_8055_(this.f_58858_)), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + height), (double)((float)this.f_58858_.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 20.0, (rand.nextDouble() + 0.5) * 2.0, (rand.nextDouble() - 0.5) / 20.0);
                    }
                    if (rand.nextInt(3) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_58857_.m_8055_(this.f_58858_)), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + height), (double)((float)this.f_58858_.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 20.0, (rand.nextDouble() + 0.5) * 2.0, (rand.nextDouble() - 0.5) / 20.0);
                    }
                    if (rand.nextInt(3) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_58857_.m_8055_(this.f_58858_)), (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + height), (double)((float)this.f_58858_.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 20.0, (rand.nextDouble() + 0.5) * 2.0, (rand.nextDouble() - 0.5) / 20.0);
                    }
                    if (rand.nextInt(3) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + height), (double)((float)this.f_58858_.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
                    }
                    if (rand.nextInt(3) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + height), (double)((float)this.f_58858_.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.045, (rand.nextDouble() - 0.5) / 50.0);
                    }
                }
                if (rand.nextInt(3) == 0) {
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * rand.nextDouble(), (double)((float)this.f_58858_.m_123342_() + height), (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * rand.nextDouble(), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.024, (rand.nextDouble() - 0.5) / 50.0);
                }
                if (rand.nextInt(3) == 0) {
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * rand.nextDouble(), (double)((float)this.f_58858_.m_123342_() + height), (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * rand.nextDouble(), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.024, (rand.nextDouble() - 0.5) / 50.0);
                }
                if (rand.nextInt(3) == 0) {
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * rand.nextDouble(), (double)((float)this.f_58858_.m_123342_() + height), (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * rand.nextDouble(), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.024, (rand.nextDouble() - 0.5) / 50.0);
                }
                if (rand.nextInt(3) == 0) {
                    this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * rand.nextDouble(), (double)((float)this.f_58858_.m_123342_() + height), (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * rand.nextDouble(), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.024, (rand.nextDouble() - 0.5) / 50.0);
                }
                if (rand.nextInt(3) != 0) continue;
                this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.CAULDRON.get(), (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * rand.nextDouble(), (double)((float)this.f_58858_.m_123342_() + height), (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * rand.nextDouble(), (rand.nextDouble() - 0.5) / 50.0, (rand.nextDouble() + 0.5) * 0.024, (rand.nextDouble() - 0.5) / 50.0);
            }
            --this.emitParticles;
        }
    }

    public BlockPos getPos() {
        return this.f_58858_;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack.copy();
    }

    public int getTankCapacity(int tank) {
        return 2000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.fluidStack.isEmpty() && !this.fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getTankCapacity(0) - this.fluidStack.getAmount());
        if (action.execute()) {
            FluidStack newStack = resource.copy();
            newStack.setAmount(this.fluidStack.getAmount() + amount);
            this.fluidStack = newStack;
            this.m_6596_();
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || this.fluidStack.isEmpty() || !this.fluidStack.getFluid().m_6212_(resource.getFluid())) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(resource.getAmount(), this.fluidStack.getAmount());
        FluidStack returnStack = this.fluidStack.copy();
        returnStack.setAmount(amount);
        if (action.execute()) {
            this.fluidStack.shrink(amount);
            this.m_6596_();
        }
        return returnStack;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.fluidStack.getAmount());
        FluidStack returnStack = this.fluidStack.copy();
        returnStack.setAmount(amount);
        if (action.execute()) {
            this.fluidStack.shrink(amount);
            this.m_6596_();
        }
        return returnStack;
    }

    public boolean interactWithFluid(IFluidHandlerItem fluidHandler) {
        if (fluidHandler.getTanks() == 0) {
            return false;
        }
        FluidStack cauldronFluid = fluidHandler.getFluidInTank(0);
        Random random = new Random();
        if (cauldronFluid.isEmpty()) {
            int amount;
            if (!this.fluidStack.isEmpty() && fluidHandler.isFluidValid(0, this.fluidStack) && (amount = fluidHandler.fill(this.fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                if (this.m_58904_() != null) {
                    this.m_58904_().m_6263_(null, (double)((float)this.getPos().m_123341_() + 0.5f), (double)((float)this.getPos().m_123342_() + 0.5f), (double)((float)this.getPos().m_123343_() + 0.5f), fluidHandler.getFluidInTank(1).getFluid().m_142520_().isPresent() ? (SoundEvent)fluidHandler.getFluidInTank(1).getFluid().m_142520_().get() : SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                this.fluidStack.shrink(amount);
                this.m_6596_();
                return true;
            }
        } else if (this.fluidStack.isEmpty() || this.fluidStack.isFluidEqual(cauldronFluid)) {
            cauldronFluid = cauldronFluid.copy();
            cauldronFluid.setAmount(this.getTankCapacity(0) - this.fluidStack.getAmount());
            FluidStack amount = fluidHandler.drain(cauldronFluid, IFluidHandler.FluidAction.SIMULATE);
            if (!amount.isEmpty() && (this.fluidStack.isEmpty() || this.fluidStack.isFluidEqual(amount))) {
                amount = fluidHandler.drain(cauldronFluid, IFluidHandler.FluidAction.EXECUTE);
                amount.grow(this.fluidStack.getAmount());
                this.fluidStack = amount;
                if (this.m_58904_() != null) {
                    this.m_58904_().m_6263_(null, (double)((float)this.getPos().m_123341_() + 0.5f), (double)((float)this.getPos().m_123342_() + 0.5f), (double)((float)this.getPos().m_123343_() + 0.5f), amount.getFluid().m_142520_().isPresent() ? (SoundEvent)amount.getFluid().m_142520_().get() : SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * random.nextFloat());
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }
}

