/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.BroomType;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.container.BroomContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomAttachmentItem;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.item.custom.BroomTickableAttachmentItem;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.BroomAskForSyncPacket;
import net.joefoxe.hexerei.util.message.BroomDamageBrushToServer;
import net.joefoxe.hexerei.util.message.BroomDamageMiscToServer;
import net.joefoxe.hexerei.util.message.BroomSyncFloatModeToServer;
import net.joefoxe.hexerei.util.message.BroomSyncPacket;
import net.joefoxe.hexerei.util.message.BroomSyncRotation;
import net.joefoxe.hexerei.util.message.BroomSyncRotationToServer;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BroomEntity
extends Entity
implements Container,
MenuProvider,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> LEFT_PADDLE = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_PADDLE = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ROCKING_TICKS = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> BROOM_TYPE = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> FIRST_SLOT = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SECOND_SLOT = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> THIRD_SLOT = SynchedEntityData.m_135353_(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float speedMultiplier = 0.75f;
    private final float[] paddlePositions = new float[2];
    private float outOfControlTicks;
    public float deltaRotation;
    public float deltaRotationOld;
    public float floatingOffset;
    public float floatingOffsetOld;
    public Vec3 deltaMovementOld;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    public boolean jumpInputDown;
    public boolean sneakingInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;
    private boolean rocking;
    private boolean downwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private final int drainTimeMax = 200;
    private int drainTime = 200;
    private final int miscDrainTimeMax = 20;
    private int miscDrainTime = 20;
    private boolean broomSync = false;
    public boolean floatMode = false;
    public boolean isItem = false;
    public boolean broomCalled = false;
    public int broomCalledDelay = 40;
    public ItemStack selfItem = null;
    public float age = 0.0f;
    public Entity prevControlling = null;
    public UUID broomUUID;
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)30, (Object)ItemStack.f_41583_);

    public BroomEntity(Level worldIn, double x, double y, double z) {
        this((EntityType<BroomEntity>)((EntityType)ModEntityTypes.BROOM.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.speedMultiplier = this.getBroomType().speedMultiplier();
    }

    public BroomEntity(EntityType<BroomEntity> broomEntityEntityType, Level world) {
        super(broomEntityEntityType, world);
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(FORWARD_DIRECTION, (Object)1);
        this.f_19804_.m_135372_(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LEFT_PADDLE, (Object)false);
        this.f_19804_.m_135372_(RIGHT_PADDLE, (Object)false);
        this.f_19804_.m_135372_(ROCKING_TICKS, (Object)0);
        this.f_19804_.m_135372_(FIRST_SLOT, (Object)0);
        this.f_19804_.m_135372_(SECOND_SLOT, (Object)0);
        this.f_19804_.m_135372_(THIRD_SLOT, (Object)0);
        this.f_19804_.m_135372_(BROOM_TYPE, (Object)"willow");
    }

    public boolean m_7337_(Entity entity) {
        return BroomEntity.func_242378_a(this, entity);
    }

    public static boolean func_242378_a(Entity p_242378_0_, Entity entity) {
        return (entity.m_5829_() || entity.m_6094_()) && !p_242378_0_.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return !this.broomCalled;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle result) {
        return PortalShape.m_77738_((BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)this.m_20182_(), (EntityDimensions)this.m_6972_(this.m_20089_()));
    }

    protected int getMaxPassengers() {
        return this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.BROOM_SEAT.get()) ? 2 : 1;
    }

    public double m_6048_() {
        float height = 2.25f;
        if (this.m_6688_() != null) {
            height = this.m_6688_().m_20206_();
        }
        return this.floatingOffset - height;
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float amount) {
        block5: {
            if (this.m_6673_(source)) {
                return false;
            }
            if (this.f_19853_.f_46443_ || this.m_213877_()) break block5;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.m_5834_();
            var5_3 = source.m_7640_();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamageTaken() > 50.0f) {
                if (!flag) {
                    this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, (double)((float)this.m_20183_().m_123341_() + 0.5f), (double)((float)this.m_20183_().m_123342_() + 0.5f), (double)((float)this.m_20183_().m_123343_() + 0.5f), this.m_142340_()));
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return true;
    }

    public static DyeColor getDyeColorNamed(BroomEntity broom) {
        if (broom.m_7770_() == null) {
            return null;
        }
        if (broom.m_7770_().getString().equals("Thunderbolt VII")) {
            return DyeColor.m_41053_((int)4);
        }
        if (broom.m_7770_().getString().equals("Firebolt")) {
            return DyeColor.m_41053_((int)14);
        }
        return HexereiUtil.getDyeColorNamed(broom.m_7770_().getString(), 0);
    }

    @NotNull
    public ItemStack m_142340_() {
        Component name;
        ItemStack item = this.getBroomItem().m_7968_();
        CompoundTag tag = item.m_41784_();
        CompoundTag inv = this.itemHandler.serializeNBT();
        boolean flag = false;
        for (int i = 0; i < 30; ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            flag = true;
            break;
        }
        if (flag) {
            tag.m_128365_("Inventory", (Tag)inv);
        }
        tag.m_128379_("floatMode", this.floatMode);
        if (this.broomUUID != null) {
            tag.m_128362_("broomUUID", this.broomUUID);
        }
        if ((name = this.m_7770_()) != null && !name.getString().isEmpty()) {
            item.m_41714_(name);
        }
        return item;
    }

    public void m_6845_(boolean downwards) {
        if (!this.f_19853_.f_46443_) {
            this.rocking = true;
            this.downwards = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        }
    }

    public void m_7334_(Entity entityIn) {
        if (entityIn instanceof BroomEntity) {
            if (entityIn.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entityIn);
            }
        } else if (entityIn.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entityIn);
        }
    }

    public Item getBroomItem() {
        return this.getBroomType().item();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6053_() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public int getExtraBrush() {
        for (int i = 3; i < 30; ++i) {
            if (!this.itemHandler.getStackInSlot(i).m_204117_(HexereiTags.Items.BROOM_BRUSH)) continue;
            return i;
        }
        return -1;
    }

    public void damageBrush() {
        this.getModule(BroomSlot.BRUSH).m_220157_(1, RandomSource.m_216327_(), null);
        if (this.getModule(BroomSlot.BRUSH).m_41773_() >= this.getModule(BroomSlot.BRUSH).m_41776_()) {
            this.setModule(BroomSlot.BRUSH, ItemStack.f_41583_);
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, this.f_19796_.m_188501_() * 0.4f + 1.0f);
            this.sync();
        }
        for (BroomSlot slot : BroomSlot.values()) {
            Item item = this.getModule(slot).m_41720_();
            if (!(item instanceof BroomAttachmentItem)) continue;
            BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
            broomAttachment.onBrushDamage(this, this.f_19796_);
        }
    }

    public void transferBrushParticles() {
        int i;
        for (i = 0; i < 20; ++i) {
            int j = this.f_19796_.m_188503_(2) * 2 - 1;
            int k = this.f_19796_.m_188503_(2) * 2 - 1;
            double d3 = this.f_19796_.m_188501_() * (float)j;
            double d4 = ((double)this.f_19796_.m_188501_() - 0.5) * 0.125;
            double d5 = this.f_19796_.m_188501_() * (float)k;
            float rotOffset = this.f_19796_.m_188501_() * 10.0f - 5.0f;
            float rot = this.f_19796_.m_188501_() * 360.0f;
            if (this.f_19796_.m_188503_(5) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0) + Math.cos(rot) * (this.f_19796_.m_188500_() * 0.05 + 0.5), this.m_20186_() + (double)this.floatingOffset + (double)(0.1f * this.f_19796_.m_188501_()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0) + Math.sin(rot) * (this.f_19796_.m_188500_() * 0.05 + 0.5), -Math.cos(rot) * (this.f_19796_.m_188500_() * 0.005 + 0.025), (this.f_19796_.m_188500_() - 0.5) * 0.005, -Math.sin(rot) * (this.f_19796_.m_188500_() * 0.005 + 0.025));
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), this.m_20186_() + (double)this.floatingOffset + (double)(0.1f * this.f_19796_.m_188501_()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), d3, d4, d5);
            Item item = this.getModule(BroomSlot.BRUSH).m_41720_();
            if (!(item instanceof BroomBrushItem)) continue;
            BroomBrushItem brushItem = (BroomBrushItem)item;
            if (brushItem.list == null) continue;
            ParticleEngine pe = Minecraft.m_91087_().f_91061_;
            Random random = new Random();
            for (Tuple<ParticleOptions, Integer> tuple : brushItem.list) {
                ParticleOptions option = (ParticleOptions)tuple.m_14418_();
                int delay = (Integer)tuple.m_14419_();
                if (random.nextInt(delay) != 0) continue;
                this.f_19853_.m_7106_(option, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), this.m_20186_() + (double)this.floatingOffset + (double)(0.25f * random.nextFloat()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), (random.nextDouble() - 0.5) * 0.05, (random.nextDouble() - 0.5) * 0.05, (random.nextDouble() - 0.5) * 0.05);
            }
        }
        for (i = 0; i < 20; ++i) {
            float rotOffset = this.f_19796_.m_188501_() * 10.0f - 5.0f;
            float rot = 18 * i;
            Item item = this.getModule(BroomSlot.BRUSH).m_41720_();
            if (!(item instanceof BroomBrushItem)) continue;
            BroomBrushItem brushItem = (BroomBrushItem)item;
            if (brushItem.list == null) continue;
            ParticleEngine pe = Minecraft.m_91087_().f_91061_;
            Random random = new Random();
            for (Tuple<ParticleOptions, Integer> tuple : brushItem.list) {
                ParticleOptions option = (ParticleOptions)tuple.m_14418_();
                int delay = (Integer)tuple.m_14419_();
                if (random.nextInt(delay) != 0) continue;
                this.f_19853_.m_7106_(option, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), this.m_20186_() + (double)this.floatingOffset + (double)(0.1f * random.nextFloat()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.m_20184_().m_82553_() / 4.0), Math.cos(rot) * (random.nextDouble() * 0.005 + 0.15), (random.nextDouble() - 0.5) * 0.005, Math.sin(rot) * (random.nextDouble() * 0.005 + 0.15));
            }
        }
    }

    public void damageMisc() {
        this.getModule(BroomSlot.MISC).m_220157_(1, RandomSource.m_216327_(), null);
        if (this.getModule(BroomSlot.MISC).m_41773_() >= this.getModule(BroomSlot.MISC).m_41776_()) {
            this.setModule(BroomSlot.MISC, ItemStack.f_41583_);
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.4f + 1.0f);
            this.sync();
        }
    }

    public void m_5856_(Player pPlayer) {
        super.m_5856_(pPlayer);
        SoundEvent sound = SoundEvents.f_11678_;
        float volume = 0.75f;
        if (this.isEnder()) {
            sound = SoundEvents.f_11889_;
            volume = 0.5f;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), sound, SoundSource.BLOCKS, volume, this.f_19796_.m_188501_() * 0.1f + 0.9f);
    }

    public void m_5785_(Player p_18954_) {
        super.m_5785_(p_18954_);
        SoundEvent sound = SoundEvents.f_11678_;
        float pitch = 0.4f;
        float volume = 0.75f;
        if (this.isEnder()) {
            sound = SoundEvents.f_11888_;
            pitch = 0.9f;
            volume = 0.5f;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), sound, SoundSource.BLOCKS, volume, this.f_19796_.m_188501_() * 0.1f + pitch);
    }

    public void m_8119_() {
        Item item;
        this.age += 1.0f;
        this.floatingOffsetOld = this.floatingOffset;
        this.deltaMovementOld = this.m_20184_();
        this.deltaRotationOld = this.deltaRotation;
        if (!this.f_19853_.f_46443_) {
            if (this.prevControlling != null && this.m_6688_() == null) {
                for (BroomSlot slot : BroomSlot.values()) {
                    item = this.getModule(slot).m_41720_();
                    if (!(item instanceof BroomAttachmentItem)) continue;
                    BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
                    broomAttachment.onDismount(this, this.f_19796_);
                }
            }
            this.prevControlling = this.m_6688_();
        }
        if (!this.broomSync && this.f_19853_ instanceof ServerLevel) {
            this.sync();
            this.broomSync = true;
        }
        if (!this.broomSync && this.f_19853_ instanceof ClientLevel) {
            if (this.f_19853_.f_46443_) {
                HexereiPacketHandler.sendToServer(new BroomAskForSyncPacket(this));
            }
            this.broomSync = true;
        }
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        if (this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER) {
            this.outOfControlTicks = 0.0f;
        } else {
            this.outOfControlTicks += 1.0f;
            if (this.getModule(BroomSlot.MISC).m_150930_((Item)ModItems.BROOM_WATERPROOF_TIP.get())) {
                this.outOfControlTicks = 0.0f;
            }
        }
        if (!this.f_19853_.f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        Entity entityPassenger = this.m_6688_();
        if (this.f_19853_.m_5776_()) {
            if (entityPassenger instanceof LivingEntity && entityPassenger.equals((Object)Hexerei.proxy.getPlayer())) {
                LocalPlayer player = (LocalPlayer)Hexerei.proxy.getPlayer();
                this.m_20242_(true);
                this.updateInputs(player.f_108618_.f_108570_, player.f_108618_.f_108571_, player.f_108618_.f_108568_, player.f_108618_.f_108569_, player.f_108618_.f_108572_, player.f_108618_.f_108573_);
            } else if (entityPassenger == null) {
                this.m_20242_(this.floatMode);
            }
        } else if (entityPassenger instanceof Player) {
            this.m_20242_(true);
        } else if (entityPassenger == null) {
            this.m_20242_(this.floatMode);
        }
        if (!this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH)) {
            this.m_20242_(false);
            this.floatMode = false;
        } else if (this.f_19853_.m_5776_()) {
            if (entityPassenger instanceof Player && (this.getPaddleState(0) || this.getPaddleState(1))) {
                --this.drainTime;
            }
            if (this.drainTime <= 0) {
                HexereiPacketHandler.sendToServer(new BroomDamageBrushToServer(this));
                this.drainTime = 200;
            }
        }
        for (BroomSlot slot : BroomSlot.values()) {
            Item item2 = this.getModule(slot).m_41720_();
            if (!(item2 instanceof BroomTickableAttachmentItem)) continue;
            BroomTickableAttachmentItem toTick = (BroomTickableAttachmentItem)item2;
            toTick.tick(this, this.getModule(slot));
        }
        super.m_8119_();
        this.tickLerp();
        if (this.isEnder() && this.f_19796_.m_188503_(5) == 0) {
            RandomSource pRandom = this.f_19796_;
            int j = pRandom.m_188503_(2) * 2 - 1;
            int k = pRandom.m_188503_(2) * 2 - 1;
            double d3 = pRandom.m_188501_() * (float)j;
            double d4 = ((double)pRandom.m_188501_() - 0.5) * 0.125;
            double d5 = pRandom.m_188501_() * (float)k;
            float rotOffset = this.f_19796_.m_188501_() * 10.0f - 5.0f;
            float rot = this.f_19796_.m_188501_() * 360.0f;
            if (this.f_19796_.m_188503_(5) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.m_20184_().m_82553_() / 4.0) + Math.cos(rot) * (this.f_19796_.m_188500_() * 0.05 + 0.5), this.m_20186_() + (double)this.floatingOffset + (double)(0.1f * this.f_19796_.m_188501_()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.m_20184_().m_82553_() / 4.0) + Math.sin(rot) * (this.f_19796_.m_188500_() * 0.05 + 0.5), -Math.cos(rot) * (this.f_19796_.m_188500_() * 0.005 + 0.025), (this.f_19796_.m_188500_() - 0.5) * 0.005, -Math.sin(rot) * (this.f_19796_.m_188500_() * 0.005 + 0.025));
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() - Math.sin((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.m_20184_().m_82553_() / 4.0), this.m_20186_() + (double)this.floatingOffset + (double)(0.1f * this.f_19796_.m_188501_()) - this.m_20184_().m_7098_(), this.m_20189_() + Math.cos((double)((this.m_146908_() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.m_20184_().m_82553_() / 4.0), d3, d4, d5);
        }
        if (this.m_6109_()) {
            Item j;
            if (this.m_20197_().isEmpty() || !(this.m_20197_().get(0) instanceof Player)) {
                this.setPaddleState(false, false);
            }
            if (this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH) && this.f_19853_.f_46443_) {
                this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.05f + (float)Math.sin((this.age * 2.0f + (float)(this.m_19879_() * 1000)) / 30.0f) * 0.15f, 0.0075f);
            }
            this.updateMotion();
            if (this.f_19853_.f_46443_) {
                this.controlBoat();
                this.f_19853_.m_5503_((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
                HexereiPacketHandler.sendToServer(new BroomSyncRotationToServer(this, this.m_146908_(), this.m_6688_()));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH) && (j = this.getModule(BroomSlot.BRUSH).m_41720_()) instanceof BroomBrushItem) {
                brushItem = (BroomBrushItem)j;
                brushItem.renderParticles(this, this.f_19853_, this.status, this.f_19796_);
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
            if (this.floatMode) {
                Item j;
                if (this.f_19853_.f_46443_) {
                    this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.05f + (float)Math.sin((this.age * 2.0f + (float)(this.m_19879_() * 1000)) / 30.0f) * 0.15f, 0.01f);
                }
                if ((j = this.getModule(BroomSlot.BRUSH).m_41720_()) instanceof BroomBrushItem) {
                    brushItem = (BroomBrushItem)j;
                    brushItem.renderParticles(this, this.f_19853_, this.status, this.f_19796_);
                }
            } else {
                this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.0f, 0.04f);
            }
        }
        this.updateRocking();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.m_20067_() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vector3d = this.m_20252_(1.0f);
                    double d0 = i == 1 ? -vector3d.f_82481_ : vector3d.f_82481_;
                    double d1 = i == 1 ? vector3d.f_82479_ : -vector3d.f_82479_;
                    this.f_19853_.m_6263_(null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        if (this.broomCalledDelay > 0) {
            --this.broomCalledDelay;
            if (this.broomCalledDelay <= 0) {
                this.broomCalled = false;
            }
        }
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && this.m_6688_() instanceof Player;
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this) || flag && this.m_20197_().size() < this.getMaxPassengers() && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) continue;
                this.m_7334_(entity);
            }
        }
        if (this.f_19853_.m_5776_() && this.m_20184_().m_82553_() >= 0.01 && this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH)) {
            BroomAttachmentItem attachmentItem;
            ItemStack misc = this.getModule(BroomSlot.MISC);
            Item entity = misc.m_41720_();
            if (entity instanceof BroomAttachmentItem && (attachmentItem = (BroomAttachmentItem)entity).shouldRenderParticles(this, this.f_19853_, this.status)) {
                attachmentItem.renderParticles(this, this.f_19853_, this.status, this.f_19796_);
            } else {
                item = this.getModule(BroomSlot.BRUSH).m_41720_();
                if (item instanceof BroomBrushItem) {
                    BroomBrushItem brushItem = (BroomBrushItem)item;
                    brushItem.renderParticles(this, this.f_19853_, this.status, this.f_19796_);
                }
            }
        }
    }

    private void updateRocking() {
        if (this.f_19853_.f_46443_) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = Mth.m_14036_((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.f_19853_.m_46467_()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vec3 vector3d = this.m_20184_();
                    if (this.downwards) {
                        this.m_20256_(vector3d.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vector3d.f_82479_, this.m_146862_(Player.class::isInstance) ? 2.7 : 0.6, vector3d.f_82481_);
                    }
                }
                this.rocking = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        return switch (this.getBoatStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case Status.IN_WATER, Status.UNDER_WATER, Status.UNDER_FLOWING_WATER -> SoundEvents.f_11707_;
            case Status.UNDER_LAVA, Status.UNDER_FLOWING_LAVA, Status.IN_AIR -> null;
            case Status.ON_LAND -> SoundEvents.f_11706_;
        };
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)((double)this.m_146908_() - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.lerpSteps));
            this.m_146926_((float)((double)this.m_146909_() + (this.lerpPitch - (double)this.m_146909_()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.f_19804_.m_135381_(LEFT_PADDLE, (Object)left);
        this.f_19804_.m_135381_(RIGHT_PADDLE, (Object)right);
    }

    private Status getBoatStatus() {
        Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB axisalignedbb = this.m_20191_();
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82292_);
        int l = Mth.m_14165_((double)(axisalignedbb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.m_123342_() + f;
        }
        return l + 1;
    }

    public float getBoatGlide() {
        AABB axisalignedbb = this.m_20191_();
        AABB axisalignedbb1 = new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_ - 0.001, axisalignedbb.f_82290_, axisalignedbb.f_82291_, axisalignedbb.f_82289_, axisalignedbb.f_82293_);
        int i = Mth.m_14107_((double)axisalignedbb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)axisalignedbb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)axisalignedbb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)axisalignedbb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)axisalignedbb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)axisalignedbb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    public boolean m_5825_() {
        return this.getModule(BroomSlot.MISC).m_150930_((Item)ModItems.BROOM_NETHERITE_TIP.get());
    }

    private boolean checkInWater() {
        AABB axisalignedbb = this.m_20191_();
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82289_);
        int l = Mth.m_14165_((double)(axisalignedbb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status getUnderwaterStatus() {
        AABB axisalignedbb = this.m_20191_();
        double d0 = axisalignedbb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        boolean flag = false;
        boolean lavaFlag = false;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (fluidstate.m_205070_(FluidTags.f_13131_) && d0 < (double)((float)blockpos$mutable.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable))) {
                        if (!fluidstate.m_76170_()) {
                            return Status.UNDER_FLOWING_WATER;
                        }
                        flag = true;
                        continue;
                    }
                    if (!fluidstate.m_205070_(FluidTags.f_13132_) || !(d0 < (double)((float)blockpos$mutable.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_LAVA;
                    }
                    lavaFlag = true;
                }
            }
        }
        if (lavaFlag) {
            return Status.UNDER_LAVA;
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float momentum = 0.05f;
        this.speedMultiplier = this.getBroomType().speedMultiplier();
        Item item = this.getModule(BroomSlot.BRUSH).m_41720_();
        if (item instanceof BroomBrushItem) {
            BroomBrushItem brush = (BroomBrushItem)item;
            this.speedMultiplier += brush.getSpeedModifier(this);
        }
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            Vec3 vector3d = this.m_20184_();
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER || this.status == Status.UNDER_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                momentum = 0.8f;
                if (this.f_19853_.m_5776_() && this.getModule(BroomSlot.MISC).m_150930_((Item)ModItems.BROOM_WATERPROOF_TIP.get())) {
                    --this.miscDrainTime;
                    if (this.miscDrainTime <= 0) {
                        HexereiPacketHandler.sendToServer(new BroomDamageMiscToServer(this));
                        this.miscDrainTime = 20;
                    }
                }
            } else if (this.status == Status.UNDER_FLOWING_LAVA || this.status == Status.UNDER_LAVA) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                momentum = 0.7f;
                if (this.f_19853_.m_5776_()) {
                    --this.miscDrainTime;
                    if (this.miscDrainTime <= 0) {
                        HexereiPacketHandler.sendToServer(new BroomDamageMiscToServer(this));
                        this.miscDrainTime = 20;
                    }
                }
            } else if (this.status == Status.IN_AIR) {
                momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                momentum = this.boatGlide;
                if (this.m_6688_() instanceof Player) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.m_20334_(vector3d.f_82479_ * (double)momentum, vector3d.f_82480_ + d1, vector3d.f_82481_ * (double)momentum);
            this.deltaRotation *= momentum;
            if (d2 > 0.0) {
                Vec3 vector3d1 = this.m_20184_();
                this.m_20334_(vector3d1.f_82479_, (vector3d1.f_82480_ + d2 * 0.06153846016296973) * 0.75, vector3d1.f_82481_);
            }
        }
        if (this.m_20068_() && Mth.m_14154_((float)((float)(this.m_20184_().m_7098_() / (double)(1.15f + Mth.m_14154_((float)((float)this.m_20184_().m_7098_())) / 6.0f)))) > 0.0f) {
            this.m_20334_(this.m_20184_().m_7096_(), Mth.m_14154_((float)((float)(this.m_20184_().m_7098_() / (double)(1.15f + Mth.m_14154_((float)((float)this.m_20184_().m_7098_())) / 6.0f)))) < 0.1f ? 0.0 : this.m_20184_().m_7098_() / (double)(1.15f + Mth.m_14154_((float)((float)this.m_20184_().m_7098_())) / 6.0f), this.m_20184_().m_7094_());
        }
        if (this.m_20184_().m_7098_() > (double)(this.speedMultiplier / 4.0f)) {
            this.m_20334_(this.m_20184_().m_7096_(), this.speedMultiplier / 4.0f, this.m_20184_().m_7094_());
        }
        if (this.m_20184_().m_7098_() < (double)(-this.speedMultiplier / 4.0f)) {
            this.m_20334_(this.m_20184_().m_7096_(), -this.speedMultiplier / 4.0f, this.m_20184_().m_7094_());
        }
    }

    private void controlBoat() {
        Options settings = Minecraft.m_91087_().f_91066_;
        boolean down = ModKeyBindings.broomDescend.m_90857_();
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.02f;
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            if (this.forwardInputDown) {
                f += 0.1f;
            }
            if (this.backInputDown) {
                f -= 0.02f;
            }
            if (this.jumpInputDown) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(0.1275f + 0.01f * this.speedMultiplier), 0.0));
            }
            if (down) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-0.1275f - 0.01f * this.speedMultiplier), 0.0));
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-(this.m_146908_() + 90.0f) * ((float)Math.PI / 180))) * f) * (double)this.speedMultiplier, 0.0, (double)(Mth.m_14089_((float)((this.m_146908_() + 90.0f) * ((float)Math.PI / 180))) * f) * (double)this.speedMultiplier));
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = 0.0f;
            float f1 = this.floatingOffset - 0.1f;
            boolean hasSeat = this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.BROOM_SEAT.get());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = -0.6f;
                    vec3 = new Vec3((double)f, 0.0, 0.0).m_82535_((float)this.m_20184_().m_7098_() * 25.0f * ((float)Math.PI / 180));
                    f1 = (float)((double)f1 + (vec3.f_82480_ + passenger.m_6049_()));
                } else {
                    f = 0.4f;
                    vec3 = new Vec3((double)f, 0.0, 0.0).m_82535_((float)this.m_20184_().m_7098_() * 25.0f * ((float)Math.PI / 180));
                    f1 = (float)((double)f1 + (vec3.f_82480_ + passenger.m_6049_() + (double)0.1f));
                }
            } else {
                f1 = (float)((double)f1 + passenger.m_6049_());
                if (hasSeat) {
                    f = 0.4f;
                    Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82535_((float)this.m_20184_().m_7098_() * 25.0f * ((float)Math.PI / 180));
                    f1 = (float)((double)f1 + (vec3.f_82480_ + (double)0.1f));
                }
            }
            if (passenger instanceof Animal) {
                f1 += 0.15f;
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_((-this.m_146908_() - this.deltaRotation * 2.0f + 90.0f) * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof Animal) {
                int j = 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        int i = -1;
        float rotation = 0.0f;
        boolean hasSeat = this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.BROOM_SEAT.get());
        if (this.m_20197_().size() > 1) {
            i = this.m_20197_().indexOf(entityToUpdate);
        }
        if (i != 0) {
            if (i == 1) {
                rotation = 90.0f;
            } else if (hasSeat) {
                rotation = 90.0f;
            }
        }
        entityToUpdate.m_5618_(this.m_146908_() + rotation);
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_() - rotation));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("BroomType", this.getBroomType().name());
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128379_("floatMode", this.floatMode);
        if (this.broomUUID != null) {
            compound.m_128362_("broomUUID", this.broomUUID);
        }
    }

    public boolean m_20223_(CompoundTag compound) {
        compound.m_128359_("BroomType", this.getBroomType().name());
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128379_("floatMode", this.floatMode);
        if (this.broomUUID != null) {
            compound.m_128362_("broomUUID", this.broomUUID);
        }
        return super.m_20223_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setBroomType(compound.m_128461_("Type"));
        }
        if (compound.m_128425_("BroomType", 8)) {
            this.setBroomType(compound.m_128461_("BroomType"));
        }
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.floatMode = compound.m_128471_("floatMode");
        if (compound.m_128441_("broomUUID")) {
            this.broomUUID = compound.m_128342_("broomUUID");
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.floatMode = compound.m_128471_("floatMode");
        if (compound.m_128425_("Type", 8)) {
            this.setBroomType(compound.m_128461_("Type"));
        }
        if (compound.m_128425_("BroomType", 8)) {
            this.setBroomType(compound.m_128461_("BroomType"));
        }
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.floatMode = compound.m_128471_("floatMode");
        if (compound.m_128441_("broomUUID")) {
            this.broomUUID = compound.m_128342_("broomUUID");
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(30){

            protected void onContentsChanged(int slot) {
                BroomEntity.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> stack.m_204117_(HexereiTags.Items.BROOM_MISC);
                    case 1 -> {
                        if (stack.m_204117_(HexereiTags.Items.SMALL_SATCHELS) || stack.m_204117_(HexereiTags.Items.MEDIUM_SATCHELS) || stack.m_204117_(HexereiTags.Items.LARGE_SATCHELS)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> stack.m_204117_(HexereiTags.Items.BROOM_BRUSH);
                    default -> true;
                };
            }

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1 || slot == 2) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private MenuProvider createContainerProvider(Level worldIn, BlockPos pos, final boolean isEnder) {
        return new MenuProvider(){

            @org.jetbrains.annotations.Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new BroomContainer(i, BroomEntity.this, playerInventory, playerEntity, isEnder);
            }

            public Component m_5446_() {
                return Component.m_237115_((String)"");
            }
        };
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            if (!this.f_19853_.m_5776_()) {
                MenuProvider containerProvider = this.createContainerProvider(this.f_19853_, this.m_20183_(), this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.ENDER_SATCHEL.get()));
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.writeInt(this.m_19879_()).writeBoolean(this.isEnder()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.f_19853_.f_46443_) {
                if (player.m_20329_((Entity)this)) {
                    for (BroomSlot slot : BroomSlot.values()) {
                        Item item = this.getModule(slot).m_41720_();
                        if (!(item instanceof BroomAttachmentItem)) continue;
                        BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
                        broomAttachment.onMount(this, this.f_19796_);
                    }
                    if (this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH)) {
                        this.m_5997_(0.0, 0.25, 0.0);
                    }
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.f_19804_.m_135370_(side == 0 ? LEFT_PADDLE : RIGHT_PADDLE) != false && this.m_6688_() != null;
    }

    public void setFloatMode(boolean floatMode) {
        this.floatMode = floatMode;
        if (this.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new BroomSyncFloatModeToServer(this, this.getFloatMode()));
        }
        this.sync();
    }

    public boolean getFloatMode() {
        return this.floatMode;
    }

    public void setRotation(float rotation) {
        this.m_146922_(rotation);
        this.f_19859_ = rotation;
        if (!this.f_19853_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new BroomSyncRotation(this, rotation));
        }
    }

    public void setDamageTaken(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    private void setRockingTicks(int ticks) {
        this.f_19804_.m_135381_(ROCKING_TICKS, (Object)ticks);
    }

    private int getRockingTicks() {
        return (Integer)this.f_19804_.m_135370_(ROCKING_TICKS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRockingAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setForwardDirection(int forwardDirection) {
        this.f_19804_.m_135381_(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.f_19804_.m_135370_(FORWARD_DIRECTION);
    }

    public void setBroomType(String broomType) {
        this.f_19804_.m_135381_(BROOM_TYPE, (Object)BroomType.byName(broomType).name());
    }

    public BroomType getBroomType() {
        return BroomType.byName((String)this.f_19804_.m_135370_(BROOM_TYPE));
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown, boolean jumpInputDown, boolean sneakingInputDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
        this.jumpInputDown = jumpInputDown;
        this.sneakingInputDown = sneakingInputDown;
        if (!this.getModule(BroomSlot.BRUSH).m_204117_(HexereiTags.Items.BROOM_BRUSH)) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.jumpInputDown = false;
            this.sneakingInputDown = false;
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean canSwim() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, this.m_146908_(), (float)this.lerpPitch);
        }
    }

    public int m_6643_() {
        return 30;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 1 && !stack.m_204117_(HexereiTags.Items.SMALL_SATCHELS)) {
            return false;
        }
        return ((ItemStack)this.items.get(index)).m_41619_();
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (itemStack.m_41613_() < 1) {
            itemStack.m_41764_(1);
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            this.items.set(index, (Object)itemStack);
        }
        this.sync();
    }

    public void m_6596_() {
    }

    public void sync() {
        this.m_6596_();
        if (!this.f_19853_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new BroomSyncPacket(this, this.m_20240_(new CompoundTag())));
        }
    }

    public boolean m_6542_(Player player) {
        if (this.m_213877_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new BroomContainer(id, this, inv, player, this.isEnder());
    }

    public boolean isEnder() {
        return this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.ENDER_SATCHEL.get());
    }

    public boolean isReplacer() {
        return this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.REPLACER_SATCHEL.get());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_213583_(Player pPlayer) {
        if (!(this.f_19853_.f_46443_ || this.m_20160_() && !this.m_20363_((Entity)pPlayer))) {
            MenuProvider containerProvider = this.createContainerProvider(this.f_19853_, this.m_20183_(), this.getModule(BroomSlot.SATCHEL).m_150930_((Item)ModItems.ENDER_SATCHEL.get()));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)containerProvider, b -> b.writeInt(this.m_19879_()).writeBoolean(this.isEnder()));
        }
    }

    public ItemStack getModule(BroomSlot slot) {
        return this.itemHandler.getStackInSlot(slot.ordinal());
    }

    public void setModule(BroomSlot slot, ItemStack module) {
        this.itemHandler.setStackInSlot(slot.ordinal(), module);
    }

    public List<ItemStack> getSatchelSlots(int satchelSize) {
        ArrayList<ItemStack> content = new ArrayList<ItemStack>();
        for (int i = 3; i < satchelSize; ++i) {
            content.add(this.itemHandler.getStackInSlot(i));
        }
        return content;
    }

    public static enum BroomSlot {
        MISC,
        SATCHEL,
        BRUSH;

    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE,
        CHARGING;


        public static AccelerationDirection fromEntity(LivingEntity entity) {
            if (entity.f_20901_ > 0.0f) {
                return FORWARD;
            }
            if (entity.f_20901_ < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }
}

