/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.loader;

import java.io.IOException;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.loader.translator.ChunkTranslator;
import net.creeperhost.levelio.loader.translator.Translator113Plus;
import net.creeperhost.levelio.loader.translator.Translator118Plus;
import net.creeperhost.levelio.loader.translator.TranslatorLegacy;

public class VersionHelper {
    public static int getChunkDataVersion(Chunk chunk) throws IOException {
        ICompoundTag tag = chunk.getChunkTag();
        if (tag.contains("DataVersion")) {
            return tag.getInt("DataVersion");
        }
        if (tag.contains("Level") && (tag = tag.getCompound("Level")).contains("DataVersion")) {
            return tag.getInt("DataVersion");
        }
        return -1;
    }

    public static ChunkTranslator getChunkTranslator(int dataVersion) {
        if (dataVersion < 1451) {
            return TranslatorLegacy.INSTANCE;
        }
        if (dataVersion < 2566) {
            return Translator113Plus.INSTANCE;
        }
        if (dataVersion < 2834) {
            return Translator113Plus.INSTANCE;
        }
        return Translator118Plus.INSTANCE;
    }
}

