/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.AndCondition;
import dev.ftb.mods.ftbranks.impl.condition.CreativeModeCondition;
import dev.ftb.mods.ftbranks.impl.condition.DimensionCondition;
import dev.ftb.mods.ftbranks.impl.condition.FakePlayerCondition;
import dev.ftb.mods.ftbranks.impl.condition.NotCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import dev.ftb.mods.ftbranks.impl.condition.OrCondition;
import dev.ftb.mods.ftbranks.impl.condition.PlaytimeCondition;
import dev.ftb.mods.ftbranks.impl.condition.RankAddedCondition;
import dev.ftb.mods.ftbranks.impl.condition.SpawnCondition;
import dev.ftb.mods.ftbranks.impl.condition.StatCondition;
import dev.ftb.mods.ftbranks.impl.condition.XorCondition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class FTBRanksAPIImpl
extends FTBRanksAPI {
    public static RankManagerImpl manager;

    @Override
    public RankManager getManager() {
        return manager;
    }

    public static void serverAboutToStart(MinecraftServer server) {
        manager = new RankManagerImpl(server);
    }

    public static void serverStarted(MinecraftServer server) {
        try {
            manager.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void serverStopped(MinecraftServer server) {
        manager = null;
    }

    public static void worldSaved(ServerLevel event) {
        if (manager != null) {
            manager.saveRanksNow();
            manager.savePlayersNow();
        }
    }

    public static void serverStarting(MinecraftServer server) {
        manager.registerCondition("always_active", (rank, json) -> AlwaysActiveCondition.INSTANCE);
        manager.registerCondition("rank_added", RankAddedCondition::new);
        manager.registerCondition("not", NotCondition::new);
        manager.registerCondition("or", OrCondition::new);
        manager.registerCondition("and", AndCondition::new);
        manager.registerCondition("xor", XorCondition::new);
        manager.registerCondition("op", (rank, tag) -> new OPCondition());
        manager.registerCondition("spawn", (rank, tag) -> new SpawnCondition());
        manager.registerCondition("dimension", (rank, tag) -> new DimensionCondition(tag));
        manager.registerCondition("playtime", (rank, tag) -> new PlaytimeCondition(tag));
        manager.registerCondition("stat", (rank, tag) -> new StatCondition(tag));
        manager.registerCondition("fake_player", (rank, tag) -> new FakePlayerCondition());
        manager.registerCondition("creative_mode", (rank, tag) -> new CreativeModeCondition());
    }
}

