/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class CreateObjectMessage
extends BaseC2SMessage {
    private final long parent;
    private final QuestObjectType type;
    private final CompoundTag nbt;
    private final CompoundTag extra;

    CreateObjectMessage(FriendlyByteBuf buffer) {
        this.parent = buffer.readLong();
        this.type = (QuestObjectType)QuestObjectType.NAME_MAP.read(buffer);
        this.nbt = buffer.m_130260_();
        this.extra = buffer.m_130260_();
    }

    public CreateObjectMessage(QuestObjectBase o, @Nullable CompoundTag e) {
        this.parent = o.getParentID();
        this.type = o.getObjectType();
        this.nbt = new CompoundTag();
        o.writeData(this.nbt);
        this.extra = e;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_OBJECT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.parent);
        QuestObjectType.NAME_MAP.write(buffer, (Object)this.type);
        buffer.m_130079_(this.nbt);
        buffer.m_130079_(this.extra);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (NetUtils.canEdit(context)) {
            QuestObjectBase object = ServerQuestFile.INSTANCE.create(this.type, this.parent, this.extra == null ? new CompoundTag() : this.extra);
            object.readData(this.nbt);
            object.id = ServerQuestFile.INSTANCE.newID();
            object.onCreated();
            object.getQuestFile().refreshIDMap();
            object.getQuestFile().clearCachedData();
            object.getQuestFile().save();
            new CreateObjectResponseMessage(object, this.extra).sendToAll(context.getPlayer().m_20194_());
        }
    }
}

