/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;

public class SelectImageScreen
extends ButtonListBaseScreen {
    private final ImageConfig imageConfig;
    private final ConfigCallback callback;
    private final SimpleTextButton refreshButton;
    private static List<ImageDetails> cachedImages = null;

    public SelectImageScreen(ImageConfig i, ConfigCallback c) {
        this.imageConfig = i;
        this.callback = c;
        this.setTitle((Component)Component.m_237113_((String)"Select Image"));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.refreshButton = new SimpleTextButton(this, (Component)Component.m_237115_((String)"ftblibrary.select_image.rescan"), Icons.REFRESH){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                SelectImageScreen.clearCachedImages();
                SelectImageScreen.this.refreshWidgets();
            }
        };
        this.refreshButton.setSize(20, 20);
    }

    private List<ImageDetails> getImageList() {
        if (cachedImages == null) {
            ArrayList images = new ArrayList();
            StringUtils.ignoreResourceLocationErrors = true;
            Map textures = Collections.emptyMap();
            try {
                textures = Minecraft.m_91087_().m_91098_().m_214159_("textures", t -> t.m_135815_().endsWith(".png"));
            }
            catch (Exception ex) {
                FTBLibrary.LOGGER.error("A mod has broken resource preventing this list from loading: " + ex);
            }
            StringUtils.ignoreResourceLocationErrors = false;
            textures.keySet().forEach(rl -> {
                if (!ResourceLocation.m_135830_((String)rl.toString())) {
                    FTBLibrary.LOGGER.warn("Image " + rl + " has invalid path! Report this to author of '" + rl.m_135827_() + "'!");
                } else if (this.isValidImage((ResourceLocation)rl)) {
                    images.add(rl);
                }
            });
            cachedImages = images.stream().sorted().map(res -> {
                ResourceLocation res1 = new ResourceLocation(res.m_135827_(), res.m_135815_().substring(9, res.m_135815_().length() - 4));
                TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(res1);
                return new ImageDetails((Component)Component.m_237113_((String)res1.m_135827_()).m_130940_(ChatFormatting.GOLD).m_130946_(":").m_7220_((Component)Component.m_237113_((String)res1.m_135815_()).m_130940_(ChatFormatting.YELLOW)), Icon.getIcon(sprite instanceof MissingTextureAtlasSprite ? res : res1));
            }).toList();
        }
        return cachedImages;
    }

    @Override
    public void alignWidgets() {
        super.alignWidgets();
        this.refreshButton.setPos(this.width + 2, 0);
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add(this.refreshButton);
    }

    public static void clearCachedImages() {
        cachedImages = null;
    }

    public boolean allowNone() {
        return true;
    }

    public boolean isValidImage(ResourceLocation id) {
        return !id.m_135815_().startsWith("textures/font/");
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.allowNone()) {
            panel.add(new SimpleTextButton(panel, (Component)Component.m_237113_((String)"None"), Color4I.EMPTY){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue("");
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
        for (final ImageDetails res : this.getImageList()) {
            panel.add(new SimpleTextButton(panel, res.label, res.icon){

                @Override
                public void onClicked(MouseButton mouseButton) {
                    this.playClickSound();
                    SelectImageScreen.this.imageConfig.setCurrentValue(res.icon.toString());
                    SelectImageScreen.this.callback.save(true);
                }
            });
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    private record ImageDetails(Component label, Icon icon) {
    }

    public static enum ResourceListener implements ResourceManagerReloadListener
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
            SelectImageScreen.clearCachedImages();
        }
    }
}

