/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class NBTConfig
extends ConfigFromString<CompoundTag> {
    public static final Component EMPTY_NBT = Component.m_237113_((String)"{}");
    public static final Component NON_EMPTY_NBT = Component.m_237113_((String)"{...}");

    @Override
    public CompoundTag copy(CompoundTag v) {
        return v.m_6426_();
    }

    @Override
    public String getStringFromValue(@Nullable CompoundTag v) {
        return v == null ? "null" : v.toString();
    }

    @Override
    public Component getStringForGUI(@Nullable CompoundTag v) {
        return v == null ? NULL_TEXT : (v.m_128456_() ? EMPTY_NBT : NON_EMPTY_NBT);
    }

    @Override
    public boolean parse(@Nullable Consumer<CompoundTag> callback, String string) {
        if (string.equals("null")) {
            if (callback != null) {
                callback.accept(null);
            }
            return true;
        }
        try {
            CompoundTag nbt = TagParser.m_129359_((String)string);
            if (callback != null) {
                callback.accept(nbt);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void addInfo(TooltipList list) {
        list.add(NBTConfig.info("Value", this.value == null ? "null" : this.value));
        list.add(NBTConfig.info("Default", this.defaultValue == null ? "null" : this.defaultValue));
    }
}

