/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbic.FTBIC;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record OreBiomeModifier(HolderSet<Biome> biomeBlacklist, GenerationStep.Decoration generationStage, HolderSet<PlacedFeature> features) implements BiomeModifier
{
    public static Codec<OreBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biome_blacklist").forGetter(OreBiomeModifier::biomeBlacklist), (App)Codec.STRING.comapFlatMap(OreBiomeModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(OreBiomeModifier::generationStage), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(OreBiomeModifier::features)).apply((Applicative)builder, OreBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && !this.biomeBlacklist.m_203333_(biome)) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            this.features.forEach(holder -> generation.m_204201_(this.generationStage, holder));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)FTBIC.ORE_BIOME_MODIFIER.get();
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }
}

