/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SimpleMachineRecipeResults
extends MachineRecipeResults {
    public final Supplier<MachineRecipeSerializer> recipeSerializer;
    private List<MachineRecipe> allRecipes;
    private Set<Item> validItems;

    public SimpleMachineRecipeResults(Supplier<MachineRecipeSerializer> s) {
        this.recipeSerializer = s;
    }

    @Override
    public List<MachineRecipe> getAllRecipes(Level level) {
        if (this.allRecipes == null) {
            this.allRecipes = new ArrayList<MachineRecipe>(level.m_7465_().m_44013_(this.recipeSerializer.get().recipeType));
            this.addAdditionalRecipes(level, this.allRecipes);
            this.allRecipes.removeIf(r -> r.inputItems.size() != 1 || r.outputItems.size() < 1);
        }
        return this.allRecipes;
    }

    protected void addAdditionalRecipes(Level level, List<MachineRecipe> list) {
    }

    @Override
    public MachineProcessingResult createResult(Level level, ItemStack[] inputs) {
        for (MachineRecipe recipe : this.getAllRecipes(level)) {
            if (recipe.inputItems.size() != 1 || recipe.outputItems.size() < 1) continue;
            IngredientWithCount c = recipe.inputItems.get(0);
            if (!c.ingredient.test(inputs[0])) continue;
            MachineProcessingResult result = new MachineProcessingResult(recipe);
            result.consume[0] = c.count;
            return result;
        }
        return MachineProcessingResult.NONE;
    }

    @Override
    public boolean canInsert(Level level, int slot, ItemStack item) {
        if (slot == 0) {
            if (this.validItems == null) {
                this.validItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 1 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)0).ingredient.m_43908_()).map(ItemStack::m_41720_).forEach(this.validItems::add);
                }
            }
            return this.validItems.contains(item.m_41720_());
        }
        return false;
    }
}

