/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.OtherPlayerInventory;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CheatCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").requires(FTBEConfig.HEAL.enabledAndOp())).executes(context -> CheatCommands.heal(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.heal(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fly").requires(FTBEConfig.FLY.enabledAndOp())).executes(context -> CheatCommands.fly(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.fly(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"god").requires(FTBEConfig.GOD.enabledAndOp())).executes(context -> CheatCommands.god(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.god(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"invsee").requires(FTBEConfig.INVSEE.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.invsee(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknamefor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknamefor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.mute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.unmute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    public static int heal(ServerPlayer player) {
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_38707_(40, 40.0f);
        player.m_20095_();
        player.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
        return 1;
    }

    public static int fly(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        Abilities abilities = player.m_150110_();
        if (data.fly) {
            data.fly = false;
            data.save();
            abilities.f_35936_ = false;
            abilities.f_35935_ = false;
            player.m_5661_((Component)Component.m_237113_((String)"Flight disabled"), true);
        } else {
            data.fly = true;
            data.save();
            abilities.f_35936_ = true;
            player.m_5661_((Component)Component.m_237113_((String)"Flight enabled"), true);
        }
        player.m_6885_();
        return 1;
    }

    public static int god(ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        Abilities abilities = player.m_150110_();
        if (data.god) {
            data.god = false;
            data.save();
            abilities.f_35934_ = false;
            player.m_5661_((Component)Component.m_237113_((String)"God mode disabled"), true);
        } else {
            data.god = true;
            data.save();
            abilities.f_35934_ = true;
            player.m_5661_((Component)Component.m_237113_((String)"God mode enabled"), true);
        }
        player.m_6885_();
        return 1;
    }

    public static int invsee(ServerPlayer source, final ServerPlayer player) {
        source.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return player.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p) {
                return new ChestMenu(MenuType.f_39961_, id, playerInventory, (Container)new OtherPlayerInventory(player), 5);
            }
        });
        return 1;
    }

    public static int nicknamefor(CommandSourceStack source, ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.m_5661_((Component)Component.m_237113_((String)"Nickname too long!"), false);
            return 0;
        }
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.nick = nick.trim();
        data.save();
        player.refreshDisplayName();
        if (data.nick.isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)"Nickname reset!"), true);
        } else {
            source.m_81354_((Component)Component.m_237113_((String)("Nickname changed to '" + data.nick + "'")), true);
        }
        data.sendTabName(source.m_81377_());
        return 1;
    }

    public static int mute(CommandSourceStack source, ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.muted = true;
        data.save();
        source.m_81354_((Component)Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" has been muted by ").m_7220_(source.m_81357_()), true);
        return 1;
    }

    public static int unmute(CommandSourceStack source, ServerPlayer player) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        data.muted = false;
        data.save();
        source.m_81354_((Component)Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" has been unmuted by ").m_7220_(source.m_81357_()), true);
        return 1;
    }
}

