/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.item.VanillaButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;

public abstract class CustomizationItemBase
extends GuiComponent {
    public String value;
    public String action;
    public int posX = 0;
    public int posY = 0;
    public String orientation = "top-left";
    public String orientationElementIdentifier = null;
    public CustomizationItemBase orientationElement = null;
    public int width = -1;
    public int height = -1;
    public String advancedWidth;
    public String advancedHeight;
    public String advancedPosX;
    public String advancedPosY;
    public volatile boolean delayAppearance = false;
    public volatile boolean delayAppearanceEverytime = false;
    public volatile float delayAppearanceSec = 1.0f;
    public volatile boolean visible = true;
    public volatile boolean fadeIn = false;
    public volatile float fadeInSpeed = 1.0f;
    public volatile float opacity = 1.0f;
    public float customGuiScale = -1.0f;
    public LoadingRequirementContainer loadingRequirementContainer;
    protected String actionId;

    public CustomizationItemBase(PropertiesSection item) {
        String h;
        String w;
        String oe;
        String o;
        String das;
        String legacyDae;
        String dae;
        String legacyDa;
        String da;
        String fis;
        String fi;
        this.action = item.getEntryValue("action");
        this.actionId = item.getEntryValue("actionid");
        if (this.actionId == null) {
            this.actionId = MenuCustomization.generateRandomActionId();
        }
        if ((fi = item.getEntryValue("fadein")) != null && fi.equalsIgnoreCase("true")) {
            this.fadeIn = true;
        }
        if ((fis = item.getEntryValue("fadeinspeed")) != null && MathUtils.isFloat((String)fis)) {
            this.fadeInSpeed = Float.parseFloat(fis);
        }
        if ((da = item.getEntryValue("delayappearance")) != null && da.equalsIgnoreCase("true")) {
            this.delayAppearance = true;
        }
        if ((legacyDa = item.getEntryValue("hideforseconds")) != null) {
            this.delayAppearance = true;
        }
        if ((dae = item.getEntryValue("delayappearanceeverytime")) != null && dae.equalsIgnoreCase("true")) {
            this.delayAppearanceEverytime = true;
        }
        if ((legacyDae = item.getEntryValue("delayonlyfirsttime")) != null && legacyDae.equalsIgnoreCase("false")) {
            this.delayAppearanceEverytime = true;
        }
        if ((das = item.getEntryValue("delayappearanceseconds")) != null && MathUtils.isFloat((String)das)) {
            this.delayAppearanceSec = Float.parseFloat(das);
        }
        if (legacyDa != null && MathUtils.isFloat((String)legacyDa)) {
            this.delayAppearanceSec = Float.parseFloat(legacyDa);
        }
        String x = item.getEntryValue("x");
        String y = item.getEntryValue("y");
        if (x != null && MathUtils.isInteger((String)(x = PlaceholderParser.replacePlaceholders(x)))) {
            this.posX = Integer.parseInt(x);
        }
        if (y != null && MathUtils.isInteger((String)(y = PlaceholderParser.replacePlaceholders(y)))) {
            this.posY = Integer.parseInt(y);
        }
        if ((o = item.getEntryValue("orientation")) != null) {
            this.orientation = o;
        }
        if ((oe = item.getEntryValue("orientation_element")) != null) {
            this.orientationElementIdentifier = oe;
        }
        if ((w = item.getEntryValue("width")) != null) {
            if (MathUtils.isInteger((String)(w = PlaceholderParser.replacePlaceholders(w)))) {
                this.width = Integer.parseInt(w);
            }
            if (this.width < 0) {
                this.width = 0;
            }
        }
        if ((h = item.getEntryValue("height")) != null) {
            if (MathUtils.isInteger((String)(h = PlaceholderParser.replacePlaceholders(h)))) {
                this.height = Integer.parseInt(h);
            }
            if (this.height < 0) {
                this.height = 0;
            }
        }
        this.advancedWidth = item.getEntryValue("advanced_width");
        this.advancedHeight = item.getEntryValue("advanced_height");
        this.advancedPosX = item.getEntryValue("advanced_posx");
        this.advancedPosY = item.getEntryValue("advanced_posy");
        this.loadingRequirementContainer = LoadingRequirementContainer.deserializeRequirementContainer(item);
    }

    public abstract void render(PoseStack var1, Screen var2) throws IOException;

    public int getPosX(Screen menu) {
        String s;
        if (this.advancedPosX != null && MathUtils.isDouble((String)(s = PlaceholderParser.replacePlaceholders(this.advancedPosX).replace(" ", "")))) {
            return (int)Double.parseDouble(s);
        }
        int w = menu.f_96543_;
        int x = this.posX;
        if (this.orientation.equalsIgnoreCase("top-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("element") && this.orientationElement != null) {
            x += this.getOrientationElementPosX(menu);
        }
        return x;
    }

    public int getPosY(Screen menu) {
        String s;
        if (this.advancedPosY != null && MathUtils.isDouble((String)(s = PlaceholderParser.replacePlaceholders(this.advancedPosY).replace(" ", "")))) {
            return (int)Double.parseDouble(s);
        }
        int h = menu.f_96544_;
        int y = this.posY;
        if (this.orientation.equalsIgnoreCase("mid-left")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-left")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            // empty if block
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("element") && this.orientationElement != null) {
            y += this.getOrientationElementPosY(menu);
        }
        return y;
    }

    public int getOrientationElementPosX(Screen menu) {
        if (this.orientationElement != null) {
            if (this.orientationElement instanceof VanillaButtonCustomizationItem) {
                AbstractWidget w = ((VanillaButtonCustomizationItem)this.orientationElement).parent.getButton();
                if (w != null) {
                    return w.f_93620_;
                }
            } else {
                return this.orientationElement.getPosX(menu);
            }
        }
        return 0;
    }

    public int getOrientationElementPosY(Screen menu) {
        if (this.orientationElement != null) {
            if (this.orientationElement instanceof VanillaButtonCustomizationItem) {
                AbstractWidget w = ((VanillaButtonCustomizationItem)this.orientationElement).parent.getButton();
                if (w != null) {
                    return w.f_93621_;
                }
            } else {
                return this.orientationElement.getPosY(menu);
            }
        }
        return 0;
    }

    public boolean shouldRender() {
        if (this.value == null) {
            return false;
        }
        if (!this.loadingRequirementsMet()) {
            return false;
        }
        return this.visible;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String id) {
        this.actionId = id;
    }

    protected static boolean isEditorActive() {
        return Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen;
    }

    protected boolean loadingRequirementsMet() {
        if (CustomizationItemBase.isEditorActive()) {
            return true;
        }
        return this.loadingRequirementContainer.requirementsMet();
    }

    public int getWidth() {
        String s;
        if (this.advancedWidth != null && MathUtils.isDouble((String)(s = PlaceholderParser.replacePlaceholders(this.advancedWidth).replace(" ", "")))) {
            return (int)Double.parseDouble(s);
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        String s;
        if (this.advancedHeight != null && MathUtils.isDouble((String)(s = PlaceholderParser.replacePlaceholders(this.advancedHeight).replace(" ", "")))) {
            return (int)Double.parseDouble(s);
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public static String fixBackslashPath(String path) {
        if (path != null) {
            return path.replace("\\", "/");
        }
        return null;
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }

        public static Alignment getByName(String name) {
            for (Alignment a : Alignment.values()) {
                if (!a.key.equals(name)) continue;
                return a;
            }
            return null;
        }
    }
}

