/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.sieve;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ConfigHolder;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.sieve.FluxSieveBlock;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxSieveTile
extends AbstractMachineTile {
    public FluxSieveTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUX_SIEVE_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean enableMeshSlot() {
        return true;
    }

    protected boolean isWaterlogged() {
        return (Boolean)this.m_58900_().m_61143_((Property)FluxSieveBlock.WATERLOGGED);
    }

    @Override
    public void tick() {
        if (this.f_58857_ instanceof ServerLevel && this.canTick(this.getUpgradeTickDelay())) {
            ItemStack meshStack;
            int quotient;
            Boolean enabled = (Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.ENABLED);
            if (Boolean.FALSE.equals(enabled)) {
                this.workStatus = WorkStatus.REDSTONE_DISABLED;
                return;
            }
            Direction output = (Direction)this.m_58900_().m_61143_((Property)AbstractMachineBlock.OUTPUT);
            BlockPos outPos = this.m_58899_().m_121945_(output);
            BlockEntity target = this.f_58857_.m_7702_(outPos);
            if (target == null) {
                this.workStatus = WorkStatus.MISSING_INVENTORY;
                return;
            }
            IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, output.m_122424_()).resolve().orElse(null);
            if (itemHandler == null || itemHandler.getSlots() == 0) {
                this.workStatus = WorkStatus.MISSING_INVENTORY;
                return;
            }
            this.workStatus = WorkStatus.WORKING;
            int cost = this.getUpgradeEnergyCost();
            int stored = this.energyStorage.getEnergyStored();
            int maxProcessed = this.getUpgradeItemsProcessed();
            if (stored < cost) {
                this.workStatus = WorkStatus.OUT_OF_ENERGY;
                return;
            }
            if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                maxProcessed = quotient;
            }
            if (!ExNihiloAPI.isMeshItem(meshStack = this.upgradeStackHandler.getStackInSlot(1))) {
                this.workStatus = WorkStatus.MISSING_MESH;
                return;
            }
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                int multiplier;
                if (maxProcessed == 0) {
                    return;
                }
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.m_41619_() || !ExNihiloAPI.canSieve(stack, meshStack, this.isWaterlogged())) continue;
                ItemStack copy = stack.m_41777_();
                int count = stack.m_41613_();
                if (count >= maxProcessed) {
                    multiplier = maxProcessed;
                    copy.m_41774_(maxProcessed);
                    maxProcessed = 0;
                } else {
                    multiplier = count;
                    copy = ItemStack.f_41583_;
                    maxProcessed -= count;
                }
                int totalCost = cost * multiplier;
                boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                if (!result) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                this.itemStackHandler.setStackInSlot(i, copy);
                this.energyStorage.consumeEnergy(totalCost, false);
                if (Boolean.TRUE.equals(ConfigHolder.SERVER.sieveBulkProcessing.get())) {
                    this.processResults(itemHandler, meshStack, stack, multiplier, false);
                    continue;
                }
                this.processResultsSingle(itemHandler, meshStack, stack, multiplier, false);
            }
        }
    }

    private boolean processResults(IItemHandler itemHandler, ItemStack meshStack, ItemStack stack, int multiplier, boolean simulate) {
        ExNihiloAPI.getSieveResult(stack, meshStack, this.isWaterlogged()).stream().map(result -> ItemStackUtil.multiplyStackCount(result, multiplier)).map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
            if (!response.m_41619_()) {
                this.workStatus = WorkStatus.INVENTORY_FULL;
            }
        });
        return this.workStatus == WorkStatus.WORKING;
    }

    private boolean processResultsSingle(IItemHandler itemHandler, ItemStack meshStack, ItemStack stack, int multiplier, boolean simulate) {
        for (int i = 0; i < multiplier; ++i) {
            ExNihiloAPI.getSieveResult(stack, meshStack, this.isWaterlogged()).stream().map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
                if (!response.m_41619_()) {
                    this.workStatus = WorkStatus.INVENTORY_FULL;
                }
            });
        }
        return this.workStatus == WorkStatus.WORKING;
    }
}

