/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.RegistryObject;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.base.DataHolder;
import net.permutated.exmachinis.machines.base.DataHolderClient;
import net.permutated.exmachinis.machines.base.DataHolderServer;
import net.permutated.exmachinis.util.WorkStatus;

public abstract class AbstractMachineMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess containerLevelAccess;
    protected final DataHolder dataHolder;
    protected final boolean enableMeshSlot;
    protected final int totalSlots;

    protected AbstractMachineMenu(@Nullable MenuType<?> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        super(containerType, windowId);
        this.enableMeshSlot = buf.readBoolean();
        this.totalSlots = this.enableMeshSlot ? 11 : 10;
        BlockPos pos = buf.m_130135_();
        Level level = playerInventory.f_35978_.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.containerLevelAccess = ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos);
            BlockEntity blockEntity = serverLevel.m_7702_(pos);
            if (blockEntity instanceof AbstractMachineTile) {
                AbstractMachineTile tile = (AbstractMachineTile)blockEntity;
                this.dataHolder = new DataHolderServer(tile);
                tile.overlay.ifPresent(this::registerHandlerSlots);
            } else {
                ExMachinis.LOGGER.error("Tried to create DataHolder on server, but did not find matching tile for pos: {}", (Object)pos);
                this.dataHolder = new DataHolderClient();
            }
        } else {
            this.containerLevelAccess = ContainerLevelAccess.f_39287_;
            this.dataHolder = new DataHolderClient();
            this.registerHandlerSlots((IItemHandler)new ItemStackHandler(this.totalSlots));
        }
        this.registerPlayerSlots((IItemHandler)new InvWrapper((Container)playerInventory));
        this.registerDataSlots();
    }

    protected abstract RegistryObject<Block> getBlock();

    protected WorkStatus getWorkStatus() {
        return this.dataHolder.getWorkStatus();
    }

    public boolean m_6875_(Player playerEntity) {
        return AbstractMachineMenu.m_38889_((ContainerLevelAccess)this.containerLevelAccess, (Player)playerEntity, (Block)((Block)this.getBlock().get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        int inventorySize = this.totalSlots;
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < inventorySize ? !this.m_38903_(stack, inventorySize, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, inventorySize, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void registerHandlerSlots(IItemHandler handler) {
        int index = 0;
        this.m_38897_((Slot)new FilteredSlot(handler, index++, 116, 54, stack -> stack.m_41720_() instanceof UpgradeItem));
        if (this.enableMeshSlot) {
            this.m_38897_((Slot)new FilteredSlot(handler, index++, 80, 36, ExNihiloAPI::isMeshItem));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(handler, index++, 8 + j * 18, 18 + i * 18));
            }
        }
    }

    public void registerPlayerSlots(IItemHandler wrappedInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(wrappedInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(wrappedInventory, i, 8 + i * 18, 142));
        }
    }

    public void registerDataSlots() {
        this.addDataSlot(this.dataHolder::getWork, this.dataHolder::setWork);
        this.addDataSlot(this.dataHolder::getMaxWork, this.dataHolder::setMaxWork);
        this.addDataSlot(() -> this.dataHolder.getWorkStatus().ordinal(), this.dataHolder::setWorkStatus);
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF0000;
            this.dataHolder.setMaxEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF;
            this.dataHolder.setMaxEnergy(energyStored | value << 16);
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF0000;
            this.dataHolder.setEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF;
            this.dataHolder.setEnergy(energyStored | value << 16);
        });
    }

    private void addDataSlot(IntSupplier getter, IntConsumer setter) {
        this.m_38895_(new LambdaDataSlot(getter, setter));
    }

    static class FilteredSlot
    extends SlotItemHandler {
        protected final Predicate<ItemStack> filter;

        public FilteredSlot(IItemHandler handler, int index, int x, int y, Predicate<ItemStack> filter) {
            super(handler, index, x, y);
            this.filter = filter;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.filter.test(stack);
        }
    }

    static class LambdaDataSlot
    extends DataSlot {
        private final IntSupplier getter;
        private final IntConsumer setter;

        public LambdaDataSlot(IntSupplier getter, IntConsumer setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public int m_6501_() {
            return this.getter.getAsInt();
        }

        public void m_6422_(int pValue) {
            this.setter.accept(pValue);
        }
    }
}

