/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.base;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineMenu;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;

public abstract class AbstractMachineBlock
extends Block
implements EntityBlock {
    public static final int VERSION = 1;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final DirectionProperty OUTPUT = DirectionProperty.m_156003_((String)"output");

    protected AbstractMachineBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 3.0f).m_60955_().m_60924_((state, getter, pos) -> false));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.TRUE)).m_61124_((Property)OUTPUT, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED, OUTPUT});
    }

    public abstract IContainerFactory<AbstractMachineMenu> containerFactory();

    public abstract BlockEntityType<? extends AbstractMachineTile> getTileType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == this.getTileType() ? AbstractMachineTile::tick : null;
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof AbstractMachineTile) {
            AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
            machineTile.dropItems();
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractMachineTile) {
                AbstractMachineTile machineTile = (AbstractMachineTile)blockEntity;
                machineTile.dropItems();
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.m_60713_(state.m_60734_())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.m_46753_(pos);
        if (!Boolean.valueOf(flag).equals(state.m_61143_((Property)ENABLED))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof AbstractMachineTile) {
                Item item;
                final AbstractMachineTile machineTile = (AbstractMachineTile)tileEntity;
                ItemStack stackInHand = player.m_21120_(hand).m_41777_();
                if (!stackInHand.m_41619_() && (item = stackInHand.m_41720_()) instanceof UpgradeItem) {
                    UpgradeItem handItem = (UpgradeItem)item;
                    ItemStack inSlot = machineTile.upgradeStackHandler.getStackInSlot(0).m_41777_();
                    if (player.m_7500_()) {
                        if (!ItemStack.m_41728_((ItemStack)inSlot, (ItemStack)stackInHand)) {
                            machineTile.upgradeStackHandler.setStackInSlot(0, stackInHand);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (inSlot.m_41619_()) {
                        ItemStack result = machineTile.upgradeStackHandler.insertItem(0, stackInHand, true);
                        if (result.m_41619_()) {
                            ItemStack actual = machineTile.upgradeStackHandler.insertItem(0, stackInHand, false);
                            player.m_21008_(hand, actual);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (inSlot.m_41656_(stackInHand)) {
                        if (inSlot.m_41613_() < inSlot.m_41741_()) {
                            ItemStack result = machineTile.upgradeStackHandler.insertItem(0, stackInHand, true);
                            int maxInsert = inSlot.m_41741_() - inSlot.m_41613_();
                            int expectedToRemain = Math.max(stackInHand.m_41613_() - maxInsert, 0);
                            if (expectedToRemain == result.m_41613_()) {
                                ItemStack actual = machineTile.upgradeStackHandler.insertItem(0, stackInHand, false);
                                player.m_21008_(hand, actual);
                                return InteractionResult.SUCCESS;
                            }
                        }
                    } else {
                        Item item2 = inSlot.m_41720_();
                        if (item2 instanceof UpgradeItem) {
                            UpgradeItem slotItem = (UpgradeItem)item2;
                            if (handItem.getTier().compareTo(slotItem.getTier()) > 0) {
                                machineTile.upgradeStackHandler.setStackInSlot(0, stackInHand);
                                player.m_21008_(hand, inSlot);
                                return InteractionResult.SUCCESS;
                            }
                        }
                    }
                }
                MenuProvider containerProvider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)AbstractMachineBlock.this.m_7705_());
                    }

                    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                        machineTile.updateContainer(buffer);
                        return AbstractMachineBlock.this.containerFactory().create(i, playerInventory, buffer);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, machineTile::updateContainer);
            } else {
                ExMachinis.LOGGER.error("tile entity not instance of AbstractMachineTile");
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }
}

