/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Constants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.util.TranslationKey;

public class CompactingCategory
implements IRecipeCategory<CompactingRecipe> {
    private final IDrawable icon;
    private final IDrawable background;
    private final MutableComponent title;
    public static final RecipeType<CompactingRecipe> RECIPE_TYPE = RecipeType.create((String)"exmachinis", (String)"compacting", CompactingRecipe.class);

    public CompactingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModRegistry.FLUX_COMPACTOR_BLOCK.get()));
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 220, 82, 34);
        this.title = Component.m_237115_((String)TranslationKey.jei("compacting"));
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<CompactingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompactingRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = Arrays.stream(recipe.getIngredient().ingredient().m_43908_()).map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)recipe.getIngredient().count())).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 9).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 9).addItemStack(recipe.getOutput());
    }
}

