/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.Config;
import dev.tr7zw.entityculling.ConfigUpgrader;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;

public abstract class EntityCullingModBase {
    public static EntityCullingModBase instance;
    public OcclusionCullingInstance culling;
    public Set<BlockEntityType<?>> blockEntityWhitelist = new HashSet();
    public Set<EntityType<?>> entityWhistelist = new HashSet();
    public Set<EntityType<?>> tickCullWhistelist = new HashSet();
    public boolean debugHitboxes = false;
    public static boolean enabled;
    public CullTask cullTask;
    private Thread cullThread;
    protected KeyMapping keybind = new KeyMapping("key.entityculling.toggle", -1, "EntityCulling");
    protected boolean pressed = false;
    private boolean configKeysLoaded = false;
    private Set<Function<BlockEntity, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<BlockEntity, Boolean>>();
    private Set<Function<Entity, Boolean>> dynamicEntityWhitelist = new HashSet<Function<Entity, Boolean>>();
    public Config config;
    private final File settingsFile = new File("config", "entityculling.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public int renderedBlockEntities = 0;
    public int skippedBlockEntities = 0;
    public int renderedEntities = 0;
    public int skippedEntities = 0;
    public int tickedEntities = 0;
    public int skippedEntityTicks = 0;

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex2) {
                System.out.println("Error while loading config! Creating a new one!");
                ex2.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhistelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> {
            System.out.println("The CullingThread has crashed! Please report the following stacktrace!");
            ex.printStackTrace();
        });
        this.cullThread.start();
        this.initModloader();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        if (!this.configKeysLoaded) {
            Optional entity;
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = Registry.f_122830_.m_6612_(new ResourceLocation(blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((BlockEntityType<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = Registry.f_122826_.m_6612_(new ResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = Registry.f_122826_.m_6612_(new ResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
        }
        if (this.keybind.m_90857_()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            enabled = !enabled;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (enabled) {
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"Culling on").m_130940_(ChatFormatting.GREEN));
                }
            } else if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Culling off").m_130940_(ChatFormatting.RED));
            }
        } else {
            this.pressed = false;
        }
        this.cullTask.requestCull = true;
    }

    public abstract void initModloader();

    public abstract AABB setupAABB(BlockEntity var1, BlockPos var2);

    public boolean isDynamicWhitelisted(BlockEntity entity) {
        for (Function<BlockEntity, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(Entity entity) {
        for (Function<Entity, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<BlockEntity, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<Entity, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }

    static {
        enabled = true;
    }
}

